/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.warning;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.WarningAction;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.warning.WarningGiveResponse;
import com.equestricraft.core.warning.WarningSession;
import com.equestricraft.core.warning.reason.WarningReasonInfo;
import com.equestricraft.core.warning.reason.WarningReasonSession;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.prompt.OptionPromptItem;
import com.equestricraft.mod.prompt.SingleSelectionOptionPrompt;
import com.equestricraft.mod.warning.WarningService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class WarningServiceImpl
implements WarningService {
    @Service
    private WarningSession warningSession;
    @Service
    private WarningReasonSession warningReasonSession;
    @Service
    private PlayerRepository playerRepository;
    private static final List<Integer> severityLevels = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5));

    @Override
    public Response giveWarningToPlayer(OnlinePlayer playerGivingWarning, String ignOfPlayerToGive, String message) {
        Optional<WarningAction> action;
        Optional<Integer> severity;
        CorePlayer playerGettingWarning = this.playerRepository.findPlayerByIgn(ignOfPlayerToGive).orElseThrow();
        List<WarningReasonInfo> reasons = this.warningReasonSession.getAvailableReasons();
        Optional<WarningReasonInfo> reason = SingleSelectionOptionPrompt.showOptionPrompt(playerGivingWarning, reasons, this::buildItem, I18n.getLabel("warning.title"), I18n.getLabel("warning.select-reason"));
        if (reason.isPresent() && (severity = SingleSelectionOptionPrompt.showOptionPrompt(playerGivingWarning, severityLevels, this::buildOptionPromptItem, I18n.getLabel("warning.title"), I18n.getLabel("warning.select-severity"))).isPresent() && (action = SingleSelectionOptionPrompt.showOptionPrompt(playerGivingWarning, Arrays.asList(WarningAction.values()), this::buildOptionPromptItem, I18n.getLabel("warning.title"), I18n.getLabel("warning.select-action", reason.get().suggestedAction().name()))).isPresent()) {
            WarningGiveResponse response = this.warningSession.giveWarning(playerGettingWarning, playerGivingWarning, severity.get(), reason.get(), message, action.get());
            playerGettingWarning.notify(message);
            if (response.warningWasGiven()) {
                return ResponseFactory.success(I18n.getLabel("warning.given", playerGettingWarning.getIgn(), response.warningId()));
            }
            return ResponseFactory.fail(response.failMessage());
        }
        return ResponseFactory.fail();
    }

    private OptionPromptItem<WarningReasonInfo> buildItem(final WarningReasonInfo r) {
        return new OptionPromptItem<WarningReasonInfo>(){

            @Override
            public int getId() {
                return r.id();
            }

            @Override
            public String getName() {
                return r.name();
            }

            @Override
            public WarningReasonInfo getItem() {
                return r;
            }
        };
    }

    private OptionPromptItem<Integer> buildOptionPromptItem(final Integer level) {
        return new OptionPromptItem<Integer>(){

            @Override
            public int getId() {
                return level;
            }

            @Override
            public String getName() {
                return level.toString();
            }

            @Override
            public Integer getItem() {
                return level;
            }
        };
    }

    private OptionPromptItem<WarningAction> buildOptionPromptItem(final WarningAction warningAction) {
        return new OptionPromptItem<WarningAction>(){

            @Override
            public int getId() {
                return warningAction.ordinal() + 1;
            }

            @Override
            public String getName() {
                return warningAction.getTranslatedName();
            }

            @Override
            public WarningAction getItem() {
                return warningAction;
            }
        };
    }
}

