/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.warp;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.warp.Warp;
import com.equestricraft.core.warp.WarpRepository;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.util.TeleportUtil;
import com.equestricraft.mod.warp.WarpService;
import java.util.Date;
import java.util.Optional;

public class WarpServiceImpl
implements WarpService {
    @Service
    private WarpRepository warpRepository;

    @Override
    public Response warpPlayer(OnlinePlayer player, String warpName) {
        Optional<Warp> warpOptional = this.warpRepository.findWarpByName(warpName);
        return warpOptional.map(w -> this.warpPlayer(player, (Warp)w)).orElse(ResponseFactory.fail(I18n.getLabel("warp.not-found", warpName)));
    }

    private Response warpPlayer(OnlinePlayer onlinePlayer, Warp warp) {
        TeleportUtil.teleportPlayer(onlinePlayer.serverPlayer(), warp.getLocation());
        warp.setLastUsedByPlayerId(onlinePlayer.getId());
        warp.setLastUsedDate(new Date());
        warp.save();
        return ResponseFactory.success(I18n.getLabel("warp.going-to", warp.getName()));
    }

    @Override
    public Response addWarp(OnlinePlayer player, String warpName, String warpDescription) {
        Optional<Warp> warpWithSameName = this.warpRepository.findWarpByName(warpName);
        if (warpWithSameName.isPresent()) {
            return ResponseFactory.fail(I18n.getLabel("warp.name-already-taken"));
        }
        DirectionalCoordinate location = player.getDirectionalCoordinate();
        Date date = new Date();
        Warp warp = new Warp(0, warpName, warpDescription, location, player.getId(), date, null, null);
        this.warpRepository.add(warp);
        return ResponseFactory.success(I18n.getLabel("warp.created"));
    }

    @Override
    public Response updateWarpLocation(OnlinePlayer player, String warpName) {
        Optional<Warp> warpOptional = this.warpRepository.findWarpByName(warpName);
        if (warpOptional.isEmpty()) {
            return ResponseFactory.fail(I18n.getLabel("warp.not-found", warpName));
        }
        Warp warp = warpOptional.get();
        warp.setLocation(player.getDirectionalCoordinate());
        warp.save();
        return ResponseFactory.success(I18n.getLabel("warp.location-updated"));
    }

    @Override
    public Response updateWarpDescription(String warpName, String warpDescription) {
        Optional<Warp> warpOptional = this.warpRepository.findWarpByName(warpName);
        if (warpOptional.isEmpty()) {
            return ResponseFactory.fail(I18n.getLabel("warp.not-found", warpName));
        }
        Warp warp = warpOptional.get();
        warp.setDescription(warpDescription);
        warp.save();
        return ResponseFactory.success(I18n.getLabel("warp.description-updated"));
    }

    @Override
    public Response deleteWarp(String warpName) {
        Optional<Warp> warpOptional = this.warpRepository.findWarpByName(warpName);
        return warpOptional.map(this::deleteWarp).orElse(ResponseFactory.fail(I18n.getLabel("warp.not-found", warpName)));
    }

    private Response deleteWarp(Warp warp) {
        this.warpRepository.remove(warp);
        return ResponseFactory.success(I18n.getLabel("warp.deleted"));
    }
}

