/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.weather;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.WeatherForecastInfo;
import com.equestricraft.core.weather.WeatherSession;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.mod.packet.ClientBoundWeatherForecastMenuOpenPacket;
import com.equestricraft.mod.player.OnlinePlayer;
import com.equestricraft.mod.weather.WeatherForecastMenuPage;
import com.equestricraft.mod.weather.WeatherService;
import java.util.Calendar;
import java.util.Date;

public class WeatherServiceImpl
implements WeatherService {
    @Service
    private WeatherSession weatherSession;

    @Override
    public void showForecastMenu(OnlinePlayer player) {
        this.showForecastMenu(player, 0);
    }

    @Override
    public void showForecastMenu(OnlinePlayer player, int dayOffset) {
        Date date = this.getDateWithDayOffset(dayOffset);
        WeatherForecastInfo forecast = this.weatherSession.getWeatherInfoForTime(date);
        String description = this.weatherSession.getForecastDescription(forecast);
        boolean hasPrevious = dayOffset > 0;
        boolean hasNext = (long)dayOffset < 14L;
        WeatherForecastMenuPage page = new WeatherForecastMenuPage(date, dayOffset, forecast, description, hasPrevious, hasNext);
        ClientBoundWeatherForecastMenuOpenPacket packet = new ClientBoundWeatherForecastMenuOpenPacket(page);
        player.sendPacket(packet);
    }

    private Date getDateWithDayOffset(int dayOffset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, dayOffset * 24);
        return calendar.getTime();
    }

    @Override
    public String getProminentWeatherEvent() {
        return this.weatherSession.getCurrentProminentWeather();
    }

    @Override
    public String getCurrentForecast() {
        return this.weatherSession.getCurrentWeatherDescription();
    }

    @Override
    public String getNextDayForecast() {
        Calendar c = Calendar.getInstance();
        c.add(10, 24);
        return this.weatherSession.getForecastForTime(c.getTime());
    }

    @Override
    public int getCurrentTemperature() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.temperature();
    }

    @Override
    public int getCurrentWindSpeed() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.windSpeed();
    }

    @Override
    public boolean isClear() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.weatherType() == WeatherType.CLEAR;
    }

    @Override
    public boolean isCloudy() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.weatherType() == WeatherType.CLOUD;
    }

    @Override
    public boolean isRaining() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.weatherType() == WeatherType.RAIN && !weather.snowing();
    }

    @Override
    public boolean isHeatwave() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.heatwave();
    }

    @Override
    public boolean isFreezing() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.freezing();
    }

    @Override
    public boolean isWindy() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.highWinds();
    }

    @Override
    public boolean isSnowing() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.snowing();
    }

    @Override
    public boolean isThunder() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.thunder();
    }

    @Override
    public boolean isFog() {
        CurrentWeather weather = this.weatherSession.getCurrentWeather();
        return weather.fog();
    }
}

