/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.weather;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.system.SubSystem;
import com.equestricraft.core.weather.WeatherForecastRepository;
import com.equestricraft.core.weather.WeatherGenerationSession;
import com.equestricraft.core.weather.config.WeatherConfigurationHandler;
import com.equestricraft.mod.weather.WeatherUpdateSession;
import com.equestricraft.mod.weather.WeatherUpdateTask;
import java.time.Duration;

public class WeatherSystem
implements SubSystem {
    @Service
    private WeatherForecastRepository weatherForecastRepository;
    @Service
    private WeatherGenerationSession weatherGenerationSession;
    @Service
    private WeatherUpdateSession weatherUpdateSession;
    private final WeatherUpdateTask weatherUpdateTask = WeatherUpdateTask.getInstance();
    private final WeatherConfigurationHandler weatherConfigurationHandler = WeatherConfigurationHandler.getInstance();

    @Override
    public void onLoad() {
        this.weatherForecastRepository.load();
    }

    @Override
    public void onEnable() {
        this.weatherConfigurationHandler.load();
        this.weatherGenerationSession.generateWeatherForecasts();
        this.weatherUpdateSession.updateWeather();
        TaskScheduler.executeAsyncTask(this.weatherUpdateSession::updateWeather, Duration.ofMinutes(2L));
        this.weatherUpdateTask.start();
    }

    @Override
    public void onDisable() {
        this.weatherUpdateTask.stop();
    }
}

