/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.weather;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.weather.CurrentWeather;
import com.equestricraft.core.weather.WeatherSession;
import com.equestricraft.core.weather.WeatherType;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.network.Network;
import com.equestricraft.mod.packet.ClientBoundWeatherChangePacket;
import com.equestricraft.mod.util.ServerLevelUtil;
import com.equestricraft.mod.weather.WeatherUpdateSession;
import net.minecraft.server.level.ServerLevel;

public class WeatherUpdateSessionImpl
implements WeatherUpdateSession {
    @Service
    private WeatherSession weatherSession;
    private static final int WEATHER_TIME = 1000000;
    private static final Log log = Log.getLogger(WeatherUpdateSessionImpl.class.getName());

    @Override
    public void updateWeather() {
        log.info("Updating weather");
        CurrentWeather newWeather = this.weatherSession.updateCurrentWeather();
        ClientBoundWeatherChangePacket weatherUpdatePacket = new ClientBoundWeatherChangePacket(newWeather);
        Network.sendToAll(weatherUpdatePacket);
        this.setWeatherInWorlds(newWeather);
    }

    private void setWeatherInWorlds(CurrentWeather weather) {
        int clear = weather.weatherType() == WeatherType.CLEAR ? 1000000 : 0;
        boolean rain = weather.weatherType() == WeatherType.RAIN;
        boolean thunder = weather.thunder();
        int rainThunder = rain || thunder ? 1000000 : 0;
        for (ServerLevel level : ServerLevelUtil.getServerLevels()) {
            if (level == null) continue;
            level.m_8606_(clear, rainThunder, rain, thunder);
        }
    }

    @Override
    public void sendWeatherUpdateToPlayer(ECPlayer player) {
        CurrentWeather currentWeather = this.weatherSession.getCurrentWeather();
        ClientBoundWeatherChangePacket weatherUpdatePacket = new ClientBoundWeatherChangePacket(currentWeather);
        player.sendPacket(weatherUpdatePacket);
    }
}

