/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.weather;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.core.weather.WeatherSettings;
import com.equestricraft.core.weather.event.WeatherEventSession;
import com.equestricraft.mod.weather.WeatherUpdateSession;
import java.time.Duration;

public class WeatherUpdateTask {
    private static final WeatherUpdateTask instance = new WeatherUpdateTask();
    @Service
    private static WeatherUpdateSession weatherUpdateSession;
    @Service
    private static WeatherEventSession weatherEventSession;
    private boolean isRunning = true;
    private boolean isEventThreadRunning = true;

    public static WeatherUpdateTask getInstance() {
        return instance;
    }

    private WeatherUpdateTask() {
    }

    public void start() {
        Thread thread2 = new Thread(this::runTask, ThreadUtils.threadName("weather-updater"));
        thread2.setDaemon(true);
        thread2.start();
        Thread eventSchedulerThread = new Thread(this::runWeatherEventScheduler, ThreadUtils.threadName("weather-event-scheduler"));
        eventSchedulerThread.setDaemon(true);
        eventSchedulerThread.start();
    }

    public void stop() {
        this.isRunning = false;
        this.isEventThreadRunning = false;
    }

    private void runTask() {
        while (this.isRunning) {
            ThreadUtils.sleep(this.determineDurationUntilNextChange());
            weatherUpdateSession.updateWeather();
        }
    }

    private Duration determineDurationUntilNextChange() {
        int minutes = NumberUtils.randomIntInRange(WeatherSettings.getUpdateIntervalMinutesMinimum(), WeatherSettings.getUpdateIntervalMinutesMaximum());
        return Duration.ofMinutes(minutes);
    }

    private void runWeatherEventScheduler() {
        while (this.isEventThreadRunning) {
            ThreadUtils.sleep(Duration.ofSeconds(10L));
            weatherEventSession.checkAndFireEvents();
        }
    }
}

