/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.world;

import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.world.WorldService;
import com.equestricraft.logging.Log;
import com.equestricraft.mod.player.OnlinePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class WorldServiceImpl
implements WorldService {
    private static final Log log = Log.getLogger(WorldServiceImpl.class.getName());

    @Override
    public boolean setTempBlockForPlayer(ECPlayer player, BlockCoordinate coordinate, String typeToSet) {
        try {
            OnlinePlayer onlinePlayer = player.require(OnlinePlayer.class);
            ServerPlayer serverPlayer = onlinePlayer.serverPlayer();
            BlockPos pos = new BlockPos(coordinate.x(), coordinate.y(), coordinate.z());
            Block block = this.getBlockFromType(typeToSet);
            if (block == null) {
                return false;
            }
            serverPlayer.f_8906_.m_141995_((Packet)new ClientboundBlockUpdatePacket(pos, block.m_49966_()));
            return true;
        }
        catch (Exception ex) {
            log.error(String.format("Failed to set temp block for player for type %s", typeToSet), ex);
            return false;
        }
    }

    private Block getBlockFromType(String typeToSet) {
        String normalized = typeToSet.toLowerCase();
        ResourceLocation blockId = normalized.contains(":") ? new ResourceLocation(normalized) : new ResourceLocation("minecraft", normalized);
        return (Block)ForgeRegistries.BLOCKS.getValue(blockId);
    }
}

