/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.mod.xp;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerService;
import com.equestricraft.mod.xp.XPService;

public class XPServiceImpl
implements XPService {
    @Service
    private PlayerService playerService;

    @Override
    public Response giveXpToPlayer(String ign, int xpToGive) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        player.getProgression().giveXp(xpToGive);
        return ResponseFactory.success(I18n.getLabel("xp.given-to-player", xpToGive, player.getIgn()));
    }

    @Override
    public Response takeXpFromPlayer(String ign, int xpToTake) {
        CorePlayer player = this.playerService.retrievePlayerByIgn(ign);
        boolean taken = player.getProgression().takeXp(xpToTake);
        if (taken) {
            return ResponseFactory.success(I18n.getLabel("xp.taken-from-player", xpToTake, player.getIgn()));
        }
        return ResponseFactory.fail(I18n.getLabel("xp.player-doesnt-have-enough", player.getIgn()));
    }
}

