/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.redis.SerializationException;
import io.lettuce.core.codec.RedisCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ObjectSerializationCodec<V>
implements RedisCodec<String, V> {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    @Override
    public String decodeKey(ByteBuffer bytes) {
        return CHARSET.decode(bytes).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V decodeValue(ByteBuffer bytes) {
        byte[] array = new byte[bytes.remaining()];
        bytes.get(array);
        try (ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(array));){
            Object object = is.readObject();
            return (V)object;
        }
        catch (Exception ex) {
            throw new SerializationException("Error deserializing data", ex);
        }
    }

    @Override
    public ByteBuffer encodeKey(String key) {
        return CHARSET.encode(key);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer encodeValue(V value) {
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            try (ObjectOutputStream os = new ObjectOutputStream(bytes);){
                os.writeObject(value);
                byteBuffer = ByteBuffer.wrap(bytes.toByteArray());
            }
            return byteBuffer;
        }
        catch (IOException ex) {
            throw new SerializationException("Error serializing data", ex);
        }
    }
}

