/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.redis.Listener;
import com.equestricraft.redis.ObjectSerializationCodec;
import com.equestricraft.redis.RedisKeepAliveConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class RedisChannelSubscription<V>
extends RedisKeepAliveConnection<V> {
    private final String channelName;
    private final List<Listener<V>> actions = new ArrayList<Listener<V>>();
    private StatefulRedisPubSubConnection<String, V> connection = null;

    public RedisChannelSubscription(String channelName) {
        this.channelName = channelName;
        this.start();
    }

    public void subscribe(Consumer<V> action) {
        Listener<V> listener = new Listener<V>(this.channelName, action);
        this.actions.add(listener);
        if (this.connection != null) {
            this.connection.addListener(listener);
        }
    }

    @Override
    protected String getName() {
        return String.format("subscription-%s", this.channelName);
    }

    @Override
    protected void connect() {
        this.connection = this.redisClient.connectPubSub(new ObjectSerializationCodec());
        this.connection.setTimeout(Duration.ofSeconds(2L));
        RedisAsyncCommands commands = this.connection.async();
        commands.subscribe(this.channelName);
        this.commands = commands;
        this.actions.forEach(this.connection::addListener);
    }
}

