/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.logging.Log;
import com.equestricraft.redis.RedisConnectionHandler;
import com.equestricraft.redis.RequestHandler;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;

public final class RedisConnection {
    private static final Log log = Log.getLogger(RedisConnection.class.getName());
    private static final RedisConnection instance = new RedisConnection();
    private final RedisClient redisClient;
    private final RedisConnectionHandler redisConnectionHandler = RedisConnectionHandler.getInstance();

    static RedisConnection get() {
        return instance;
    }

    private RedisConnection() {
        this.redisClient = this.start(System.getenv("EC_REDIS_HOST"));
    }

    private RedisClient start(String url) {
        if (url == null || url.isBlank()) {
            throw new IllegalArgumentException("Missing Redis URL");
        }
        RedisClient client = RedisClient.create(url);
        try {
            ClientOptions options = ClientOptions.builder().autoReconnect(true).pingBeforeActivateConnection(true).build();
            client.setOptions(options);
            RequestHandler.setUp(client);
            this.redisConnectionHandler.start();
            Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        }
        catch (Exception ex) {
            log.error("Error connecting to redis", ex);
        }
        return client;
    }

    RedisClient getRedisClient() {
        return this.redisClient;
    }

    private void close() {
        log.info("Closing Redis connection");
        this.redisConnectionHandler.stop();
        this.redisClient.shutdown();
    }
}

