/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.logging.Log;
import com.equestricraft.redis.RedisKeepAliveConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.StampedLock;

public class RedisConnectionHandler {
    private static final RedisConnectionHandler instance = new RedisConnectionHandler();
    private final Timer keepAliveTimer = new Timer(ThreadUtils.threadName("redis-keep-alive"));
    private final List<RedisKeepAliveConnection<?>> connections = new ArrayList(0);
    private final StampedLock connectionsLock = new StampedLock();
    private static final Log log = Log.getLogger(RedisConnectionHandler.class.getName());

    protected static RedisConnectionHandler getInstance() {
        return instance;
    }

    private RedisConnectionHandler() {
    }

    public void start() {
        long duration = Duration.ofSeconds(5L).toMillis();
        this.keepAliveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    RedisConnectionHandler.this.pingAllConnections();
                }
                catch (Exception ex) {
                    log.error("Error pinging connections", ex);
                }
            }
        }, duration, duration);
    }

    public void stop() {
        this.keepAliveTimer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingAllConnections() {
        long stamp = this.connectionsLock.readLock();
        try {
            for (RedisKeepAliveConnection<?> connection : this.connections) {
                if (connection.isAlive()) continue;
                log.warn("Redis connection {} has gone down, will reconnect", (Object)connection.getName());
                connection.reconnect();
            }
        }
        finally {
            this.connectionsLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void addConnection(RedisKeepAliveConnection<V> connection) {
        long stamp = this.connectionsLock.writeLock();
        try {
            this.connections.add(connection);
        }
        finally {
            this.connectionsLock.unlockWrite(stamp);
        }
    }
}

