/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.common.ListMap;
import com.equestricraft.redis.RedisChannelSubscription;
import com.equestricraft.redis.RedisPublishChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class RedisEventBus {
    private final RedisPublishChannel<String> eventBusPublishChannel = new RedisPublishChannel("event_bus");
    private final ListMap<String, Runnable> eventListeners = new ListMap();
    private final List<Consumer<String>> allEventListeners = new ArrayList<Consumer<String>>();
    private static final RedisEventBus instance = new RedisEventBus();
    private static final String EVENT_BUS_CHANNEL_NAME = "event_bus";

    private RedisEventBus() {
        RedisChannelSubscription<String> eventBusChannelSubscription = new RedisChannelSubscription<String>(EVENT_BUS_CHANNEL_NAME);
        eventBusChannelSubscription.subscribe(event -> {
            this.allEventListeners.forEach(l -> l.accept(event));
            List<Runnable> listeners = this.eventListeners.get((String)event);
            listeners.forEach(Runnable::run);
        });
    }

    public void postEvent(String eventName) {
        this.eventBusPublishChannel.publish(eventName);
    }

    public void subscribeToEvent(String eventName, Runnable onEvent) {
        this.eventListeners.add(eventName, onEvent);
    }

    public void subscribeToAll(Consumer<String> consumer) {
        this.allEventListeners.add(consumer);
    }

    public static RedisEventBus getInstance() {
        return instance;
    }
}

