/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.common.util.ThreadUtils;
import com.equestricraft.logging.Log;
import com.equestricraft.redis.RedisConnection;
import com.equestricraft.redis.RedisConnectionHandler;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.async.RedisAsyncCommands;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class RedisKeepAliveConnection<V> {
    private static final Timer reconnectTimer = new Timer(ThreadUtils.threadName("redis-reconnect"));
    private final AtomicInteger failedConnectionAttempts = new AtomicInteger();
    protected final RedisClient redisClient = RedisConnection.get().getRedisClient();
    protected RedisAsyncCommands<String, V> commands = null;
    protected final Lock lock = new ReentrantLock();
    private static final Log log = Log.getLogger(RedisKeepAliveConnection.class.getName());

    protected abstract String getName();

    protected final void start() {
        RedisConnectionHandler.getInstance().addConnection(this);
        this.reconnect();
    }

    protected final void reconnect() {
        try {
            this.connect();
            this.failedConnectionAttempts.set(0);
        }
        catch (Exception ex) {
            int failed = this.failedConnectionAttempts.incrementAndGet();
            if (failed % 5 == 0) {
                log.error("Redis connection {} has failed {} times in a row", (Object)this.getName(), (Object)failed);
            } else {
                log.info("Redis connection {} has failed", (Object)this.getName());
            }
            reconnectTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    RedisKeepAliveConnection.this.reconnect();
                }
            }, Duration.ofSeconds(5L).toMillis());
        }
    }

    protected abstract void connect();

    protected final boolean isAlive() {
        if (this.commands == null) {
            return false;
        }
        try {
            this.lock.lock();
            try {
                this.commands.ping();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

