/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.redis.ObjectSerializationCodec;
import com.equestricraft.redis.RedisKeepAliveConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.time.Duration;

public class RedisPublishChannel<V>
extends RedisKeepAliveConnection<V> {
    private final String channelName;

    public RedisPublishChannel(String channelName) {
        this.channelName = channelName;
        this.start();
    }

    public void publish(V message) {
        if (this.commands == null) {
            return;
        }
        this.lock.lock();
        try {
            this.commands.publish(this.channelName, message);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected String getName() {
        return String.format("publish-%s", this.channelName);
    }

    @Override
    protected void connect() {
        StatefulRedisPubSubConnection connection = this.redisClient.connectPubSub(new ObjectSerializationCodec());
        connection.setTimeout(Duration.ofSeconds(2L));
        this.commands = connection.async();
    }
}

