/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.redis;

import com.equestricraft.redis.RedisChannelSubscription;
import com.equestricraft.redis.RedisPublishChannel;
import java.io.Serializable;

public class RedisSyncField<T extends Serializable> {
    private final RedisPublishChannel<T> publishChannel;
    private T currentValue = null;

    public static <T extends Serializable> RedisSyncField<T> createField(String name) {
        return new RedisSyncField<T>(name);
    }

    private RedisSyncField(String name) {
        this.publishChannel = new RedisPublishChannel("sync_field_" + name);
        RedisChannelSubscription<Serializable> subscribeChannel = new RedisChannelSubscription<Serializable>("sync_field_" + name);
        subscribeChannel.subscribe(newValue -> {
            this.currentValue = newValue;
        });
    }

    public T getValue() {
        return this.currentValue;
    }

    public void setValue(T value) {
        this.publishChannel.publish(value);
    }
}

