/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.settings;

import com.equestricraft.common.ReflectionHelper;
import com.equestricraft.logging.Log;
import com.equestricraft.settings.Setting;
import com.equestricraft.settings.SettingDescription;
import com.equestricraft.settings.SettingEntry;
import com.equestricraft.settings.SettingName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class SettingsController {
    private boolean initialLoadDone = false;
    private static final Log log = Log.getLogger(SettingsController.class.getName());

    public List<String> load() throws IllegalAccessException {
        ArrayList<String> updatedKeys = new ArrayList<String>(0);
        List<Field> fields = ReflectionHelper.scanFieldsAnnotatedWith(Setting.class);
        for (Field field : fields) {
            String description;
            Setting keyAnnotation = field.getAnnotation(Setting.class);
            SettingName nameAnnotation = field.getAnnotation(SettingName.class);
            SettingDescription descriptionAnnotation = field.getAnnotation(SettingDescription.class);
            String key = keyAnnotation.value();
            String name = nameAnnotation != null ? nameAnnotation.value() : key;
            String string = description = descriptionAnnotation != null ? descriptionAnnotation.value() : key;
            if (Modifier.isStatic(field.getModifiers())) {
                Optional<SettingEntry> existingEntry = this.getSettingFromDatasource(key);
                if (existingEntry.isPresent()) {
                    boolean updated = this.setFieldValue(field, existingEntry.get().value());
                    if (this.initialLoadDone && updated) {
                        updatedKeys.add(key);
                    }
                    SettingEntry settingEntry = new SettingEntry(key, name, description, existingEntry.get().value());
                    this.updateSettingInDatasource(settingEntry);
                    continue;
                }
                boolean canAccess = field.canAccess(null);
                if (!canAccess) {
                    field.setAccessible(true);
                }
                Object value = field.get(null);
                if (!canAccess) {
                    field.setAccessible(false);
                }
                SettingEntry settingEntry = new SettingEntry(key, name, description, value.toString());
                this.persistNewSettingToDatasource(settingEntry);
                continue;
            }
            log.warn("Setting {} on field {} in class {} is not static, so it will be ignored", key, field.getName(), field.getDeclaringClass().getName());
        }
        this.initialLoadDone = true;
        return Collections.unmodifiableList(updatedKeys);
    }

    private boolean setFieldValue(Field field, String value) throws IllegalAccessException {
        boolean canAccess = field.canAccess(null);
        if (!canAccess) {
            field.setAccessible(true);
        }
        try {
            if (field.getType() == String.class) {
                String currentValue = (String)field.get(null);
                field.set(null, value);
                boolean bl = !currentValue.equals(value);
                return bl;
            }
            if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                Integer currentValue = (Integer)field.get(null);
                Integer newValue = Integer.parseInt(value);
                field.set(null, newValue);
                boolean bl = !currentValue.equals(newValue);
                return bl;
            }
            if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                Double currentValue = (Double)field.get(null);
                Double newValue = Double.parseDouble(value);
                field.set(null, newValue);
                boolean bl = !currentValue.equals(newValue);
                return bl;
            }
            if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                Long currentValue = (Long)field.get(null);
                Long newValue = Long.parseLong(value);
                field.set(null, newValue);
                boolean bl = !currentValue.equals(newValue);
                return bl;
            }
            if (field.getType() == Float.class || field.getType() == Float.TYPE) {
                Float currentValue = (Float)field.get(null);
                Float newValue = Float.valueOf(Float.parseFloat(value));
                field.set(null, newValue);
                boolean bl = !currentValue.equals(newValue);
                return bl;
            }
            if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                Boolean currentValue = (Boolean)field.get(null);
                Boolean newValue = Boolean.parseBoolean(value);
                field.set(null, newValue);
                boolean bl = !currentValue.equals(newValue);
                return bl;
            }
            throw new IllegalAccessException(String.format("Field %s has an unsupported setting type %s", field.getName(), field.getType().getName()));
        }
        finally {
            if (!canAccess) {
                field.setAccessible(false);
            }
        }
    }

    protected abstract Optional<SettingEntry> getSettingFromDatasource(String var1);

    protected abstract void persistNewSettingToDatasource(SettingEntry var1);

    protected abstract void updateSettingInDatasource(SettingEntry var1);
}

