/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.synchronizer;

import com.equestricraft.redis.RedisChannelSubscription;
import com.equestricraft.redis.RedisPublishChannel;
import com.equestricraft.synchronizer.SystemStateMessage;
import java.util.function.Consumer;

public class SystemStatePublisher {
    private final String name;
    private final RedisPublishChannel<SystemStateMessage> systemStatePublishChannel = new RedisPublishChannel("system_state");
    private final RedisChannelSubscription<SystemStateMessage> systemStateSubscription = new RedisChannelSubscription("system_state");
    private static final String CHANNEL_SYSTEM_STATE = "system_state";

    public static SystemStatePublisher createInstance(String name) {
        return new SystemStatePublisher(name);
    }

    private SystemStatePublisher(String name) {
        this.name = name;
    }

    public void publishHealthyState() {
        this.publishHealthyState(null);
    }

    public void publishHealthyState(String message) {
        this.publishUpState(false, message);
    }

    public void publishImpairedState() {
        this.publishImpairedState(null);
    }

    public void publishImpairedState(String message) {
        this.publishUpState(true, message);
    }

    public void publishUpState(boolean impaired, String message) {
        this.publishMessage(true, impaired, message);
    }

    public void publishSystemDown() {
        this.publishMessage(false, false, "Server shutdown");
    }

    private void publishMessage(boolean up, boolean impaired, String message) {
        SystemStateMessage state = new SystemStateMessage(this.name, up, impaired, message);
        this.systemStatePublishChannel.publish(state);
    }

    public void subscribe(Consumer<SystemStateMessage> consumer) {
        this.systemStateSubscription.subscribe(consumer);
    }
}

