/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing.binding;

import org.apache.groovy.swing.binding.AbstractFullBinding;
import org.apache.groovy.swing.binding.PropertyBinding;
import org.apache.groovy.swing.binding.SourceBinding;
import org.apache.groovy.swing.binding.TargetBinding;

public abstract class AbstractSyntheticBinding
extends AbstractFullBinding {
    boolean bound;
    String propertyName;
    Class klass;

    public AbstractSyntheticBinding(PropertyBinding source2, TargetBinding target, Class klass, String propertyName) {
        this.propertyName = propertyName;
        this.klass = klass;
        this.bound = false;
        this.setSourceBinding(source2);
        this.setTargetBinding(target);
    }

    @Override
    public void bind() {
        if (!this.bound) {
            try {
                this.syntheticBind();
                this.bound = true;
            }
            catch (RuntimeException re) {
                try {
                    this.syntheticUnbind();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw re;
            }
        }
    }

    @Override
    public void unbind() {
        if (this.bound) {
            this.bound = false;
            this.syntheticUnbind();
        }
    }

    protected abstract void syntheticBind();

    protected abstract void syntheticUnbind();

    @Override
    public void rebind() {
        if (this.bound) {
            this.unbind();
            this.bind();
        }
    }

    @Override
    public void setSourceBinding(SourceBinding source2) {
        if (!(source2 instanceof PropertyBinding)) {
            throw new IllegalArgumentException("Only PropertySourceBindings are accepted");
        }
        if (!this.propertyName.equals(((PropertyBinding)source2).getPropertyName())) {
            throw new IllegalArgumentException("PropertyName must be '" + this.propertyName + "'");
        }
        Object bean = ((PropertyBinding)source2).getBean();
        if (bean == null || !this.klass.isAssignableFrom(bean.getClass())) {
            throw new IllegalArgumentException("SourceBean must be a " + this.klass.getName());
        }
        super.setSourceBinding(source2);
    }

    @Override
    public void setTargetBinding(TargetBinding target) {
        super.setTargetBinding(target);
    }
}

