/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing.model;

import groovy.lang.Closure;
import groovy.swing.model.NestedValueModel;
import groovy.swing.model.ValueModel;

public class ClosureModel
implements ValueModel,
NestedValueModel {
    private final ValueModel sourceModel;
    private final Closure readClosure;
    private final Closure writeClosure;
    private final Class type;

    public ClosureModel(ValueModel sourceModel, Closure readClosure) {
        this(sourceModel, readClosure, null);
    }

    public ClosureModel(ValueModel sourceModel, Closure readClosure, Closure writeClosure) {
        this(sourceModel, readClosure, writeClosure, Object.class);
    }

    public ClosureModel(ValueModel sourceModel, Closure readClosure, Closure writeClosure, Class type) {
        this.sourceModel = sourceModel;
        this.readClosure = readClosure;
        this.writeClosure = writeClosure;
        this.type = type;
    }

    @Override
    public ValueModel getSourceModel() {
        return this.sourceModel;
    }

    @Override
    public Object getValue() {
        Object source2 = this.sourceModel.getValue();
        if (source2 != null) {
            return this.readClosure.call(source2);
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        Object source2;
        if (this.writeClosure != null && (source2 = this.sourceModel.getValue()) != null) {
            this.writeClosure.call(source2, value);
        }
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public boolean isEditable() {
        return this.writeClosure != null;
    }
}

