/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.AclCategory;
import io.lettuce.core.AclSetuserArgs;
import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.ClientListArgs;
import io.lettuce.core.Consumer;
import io.lettuce.core.CopyArgs;
import io.lettuce.core.ExpireArgs;
import io.lettuce.core.FlushMode;
import io.lettuce.core.FunctionRestoreMode;
import io.lettuce.core.GeoAddArgs;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoRadiusStoreArgs;
import io.lettuce.core.GeoSearch;
import io.lettuce.core.GeoValue;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.KillArgs;
import io.lettuce.core.LMPopArgs;
import io.lettuce.core.LMoveArgs;
import io.lettuce.core.LPosArgs;
import io.lettuce.core.Limit;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.Range;
import io.lettuce.core.RedisCommandBuilder;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RestoreArgs;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.ShutdownArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StrAlgoArgs;
import io.lettuce.core.StreamMessage;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.StringMatchResult;
import io.lettuce.core.TrackingArgs;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.UnblockType;
import io.lettuce.core.Value;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XAutoClaimArgs;
import io.lettuce.core.XClaimArgs;
import io.lettuce.core.XGroupCreateArgs;
import io.lettuce.core.XPendingArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.XTrimArgs;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZAggregateArgs;
import io.lettuce.core.ZPopArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisAclAsyncCommands;
import io.lettuce.core.api.async.RedisGeoAsyncCommands;
import io.lettuce.core.api.async.RedisHLLAsyncCommands;
import io.lettuce.core.api.async.RedisHashAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisListAsyncCommands;
import io.lettuce.core.api.async.RedisScriptingAsyncCommands;
import io.lettuce.core.api.async.RedisServerAsyncCommands;
import io.lettuce.core.api.async.RedisSetAsyncCommands;
import io.lettuce.core.api.async.RedisSortedSetAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.async.RedisTransactionalAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.codec.Base16;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.stream.ClaimedMessages;
import io.lettuce.core.models.stream.PendingMessage;
import io.lettuce.core.models.stream.PendingMessages;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRedisAsyncCommands<K, V>
implements RedisAclAsyncCommands<K, V>,
RedisHashAsyncCommands<K, V>,
RedisKeyAsyncCommands<K, V>,
RedisStringAsyncCommands<K, V>,
RedisListAsyncCommands<K, V>,
RedisSetAsyncCommands<K, V>,
RedisSortedSetAsyncCommands<K, V>,
RedisScriptingAsyncCommands<K, V>,
RedisServerAsyncCommands<K, V>,
RedisHLLAsyncCommands<K, V>,
BaseRedisAsyncCommands<K, V>,
RedisTransactionalAsyncCommands<K, V>,
RedisGeoAsyncCommands<K, V>,
RedisClusterAsyncCommands<K, V> {
    private final StatefulConnection<K, V> connection;
    private final RedisCommandBuilder<K, V> commandBuilder;

    public AbstractRedisAsyncCommands(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.commandBuilder = new RedisCommandBuilder<K, V>(codec);
    }

    @Override
    public RedisFuture<Set<AclCategory>> aclCat() {
        return this.dispatch(this.commandBuilder.aclCat());
    }

    @Override
    public RedisFuture<Set<CommandType>> aclCat(AclCategory category) {
        return this.dispatch(this.commandBuilder.aclCat(category));
    }

    @Override
    public RedisFuture<Long> aclDeluser(String ... usernames) {
        return this.dispatch(this.commandBuilder.aclDeluser(usernames));
    }

    @Override
    public RedisFuture<String> aclDryRun(String username, String command, String ... args2) {
        return this.dispatch(this.commandBuilder.aclDryRun(username, command, args2));
    }

    @Override
    public RedisFuture<String> aclDryRun(String username, RedisCommand<K, V, ?> command) {
        return this.dispatch(this.commandBuilder.aclDryRun(username, command));
    }

    @Override
    public RedisFuture<String> aclGenpass() {
        return this.dispatch(this.commandBuilder.aclGenpass());
    }

    @Override
    public RedisFuture<String> aclGenpass(int bits) {
        return this.dispatch(this.commandBuilder.aclGenpass(bits));
    }

    @Override
    public RedisFuture<List<Object>> aclGetuser(String username) {
        return this.dispatch(this.commandBuilder.aclGetuser(username));
    }

    @Override
    public RedisFuture<List<String>> aclList() {
        return this.dispatch(this.commandBuilder.aclList());
    }

    @Override
    public RedisFuture<String> aclLoad() {
        return this.dispatch(this.commandBuilder.aclLoad());
    }

    @Override
    public RedisFuture<List<Map<String, Object>>> aclLog() {
        return this.dispatch(this.commandBuilder.aclLog());
    }

    @Override
    public RedisFuture<List<Map<String, Object>>> aclLog(int count) {
        return this.dispatch(this.commandBuilder.aclLog(count));
    }

    @Override
    public RedisFuture<String> aclLogReset() {
        return this.dispatch(this.commandBuilder.aclLogReset());
    }

    @Override
    public RedisFuture<String> aclSave() {
        return this.dispatch(this.commandBuilder.aclSave());
    }

    @Override
    public RedisFuture<String> aclSetuser(String username, AclSetuserArgs args2) {
        return this.dispatch(this.commandBuilder.aclSetuser(username, args2));
    }

    @Override
    public RedisFuture<List<String>> aclUsers() {
        return this.dispatch(this.commandBuilder.aclUsers());
    }

    @Override
    public RedisFuture<String> aclWhoami() {
        return this.dispatch(this.commandBuilder.aclWhoami());
    }

    @Override
    public RedisFuture<Long> append(K key, V value) {
        return this.dispatch(this.commandBuilder.append(key, value));
    }

    @Override
    public RedisFuture<String> asking() {
        return this.dispatch(this.commandBuilder.asking());
    }

    @Override
    public RedisFuture<String> auth(CharSequence password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        return this.dispatch(this.commandBuilder.auth(password));
    }

    public RedisFuture<String> auth(char[] password) {
        LettuceAssert.notNull((Object)password, "Password must not be null");
        return this.dispatch(this.commandBuilder.auth(password));
    }

    @Override
    public RedisFuture<String> auth(String username, CharSequence password) {
        LettuceAssert.notNull((Object)username, "Username must not be null");
        LettuceAssert.notNull((Object)password, "Password must not be null");
        return this.dispatch(this.commandBuilder.auth(username, password));
    }

    public RedisFuture<String> auth(String username, char[] password) {
        LettuceAssert.notNull((Object)username, "Username must not be null");
        LettuceAssert.notNull((Object)password, "Password must not be null");
        return this.dispatch(this.commandBuilder.auth(username, password));
    }

    @Override
    public RedisFuture<String> bgrewriteaof() {
        return this.dispatch(this.commandBuilder.bgrewriteaof());
    }

    @Override
    public RedisFuture<String> bgsave() {
        return this.dispatch(this.commandBuilder.bgsave());
    }

    @Override
    public RedisFuture<Long> bitcount(K key) {
        return this.dispatch(this.commandBuilder.bitcount(key));
    }

    @Override
    public RedisFuture<Long> bitcount(K key, long start, long end) {
        return this.dispatch(this.commandBuilder.bitcount(key, start, end));
    }

    @Override
    public RedisFuture<List<Long>> bitfield(K key, BitFieldArgs bitFieldArgs) {
        return this.dispatch(this.commandBuilder.bitfield(key, bitFieldArgs));
    }

    @Override
    public RedisFuture<Long> bitopAnd(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.bitopAnd(destination, keys2));
    }

    @Override
    public RedisFuture<Long> bitopNot(K destination, K source2) {
        return this.dispatch(this.commandBuilder.bitopNot(destination, source2));
    }

    @Override
    public RedisFuture<Long> bitopOr(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.bitopOr(destination, keys2));
    }

    @Override
    public RedisFuture<Long> bitopXor(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.bitopXor(destination, keys2));
    }

    @Override
    public RedisFuture<Long> bitpos(K key, boolean state) {
        return this.dispatch(this.commandBuilder.bitpos(key, state));
    }

    @Override
    public RedisFuture<Long> bitpos(K key, boolean state, long start) {
        return this.dispatch(this.commandBuilder.bitpos(key, state, start));
    }

    @Override
    public RedisFuture<Long> bitpos(K key, boolean state, long start, long end) {
        return this.dispatch(this.commandBuilder.bitpos(key, state, start, end));
    }

    @Override
    public RedisFuture<V> blmove(K source2, K destination, LMoveArgs args2, long timeout2) {
        return this.dispatch(this.commandBuilder.blmove(source2, destination, args2, timeout2));
    }

    @Override
    public RedisFuture<V> blmove(K source2, K destination, LMoveArgs args2, double timeout2) {
        return this.dispatch(this.commandBuilder.blmove(source2, destination, args2, timeout2));
    }

    @Override
    public RedisFuture<KeyValue<K, List<V>>> blmpop(long timeout2, LMPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.blmpop(timeout2, args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, List<V>>> blmpop(double timeout2, LMPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.blmpop(timeout2, args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, V>> blpop(long timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.blpop(timeout2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, V>> blpop(double timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.blpop(timeout2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, V>> brpop(long timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.brpop(timeout2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, V>> brpop(double timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.brpop(timeout2, keys2));
    }

    @Override
    public RedisFuture<V> brpoplpush(long timeout2, K source2, K destination) {
        return this.dispatch(this.commandBuilder.brpoplpush(timeout2, source2, destination));
    }

    @Override
    public RedisFuture<V> brpoplpush(double timeout2, K source2, K destination) {
        return this.dispatch(this.commandBuilder.brpoplpush(timeout2, source2, destination));
    }

    @Override
    public RedisFuture<String> clientCaching(boolean enabled) {
        return this.dispatch(this.commandBuilder.clientCaching(enabled));
    }

    @Override
    public RedisFuture<K> clientGetname() {
        return this.dispatch(this.commandBuilder.clientGetname());
    }

    @Override
    public RedisFuture<Long> clientGetredir() {
        return this.dispatch(this.commandBuilder.clientGetredir());
    }

    @Override
    public RedisFuture<String> clientKill(String addr) {
        return this.dispatch(this.commandBuilder.clientKill(addr));
    }

    @Override
    public RedisFuture<Long> clientKill(KillArgs killArgs) {
        return this.dispatch(this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public RedisFuture<String> clientList() {
        return this.dispatch(this.commandBuilder.clientList());
    }

    @Override
    public RedisFuture<String> clientList(ClientListArgs clientListArgs) {
        return this.dispatch(this.commandBuilder.clientList(clientListArgs));
    }

    @Override
    public RedisFuture<String> clientInfo() {
        return this.dispatch(this.commandBuilder.clientInfo());
    }

    @Override
    public RedisFuture<String> clientNoEvict(boolean on) {
        return this.dispatch(this.commandBuilder.clientNoEvict(on));
    }

    @Override
    public RedisFuture<Long> clientId() {
        return this.dispatch(this.commandBuilder.clientId());
    }

    @Override
    public RedisFuture<String> clientPause(long timeout2) {
        return this.dispatch(this.commandBuilder.clientPause(timeout2));
    }

    @Override
    public RedisFuture<String> clientSetname(K name) {
        return this.dispatch(this.commandBuilder.clientSetname(name));
    }

    @Override
    public RedisFuture<String> clientSetinfo(String key, String value) {
        return this.dispatch(this.commandBuilder.clientSetinfo(key, value));
    }

    @Override
    public RedisFuture<String> clientTracking(TrackingArgs args2) {
        return this.dispatch(this.commandBuilder.clientTracking(args2));
    }

    @Override
    public RedisFuture<Long> clientUnblock(long id, UnblockType type) {
        return this.dispatch(this.commandBuilder.clientUnblock(id, type));
    }

    @Override
    public RedisFuture<String> clusterAddSlots(int ... slots) {
        return this.dispatch(this.commandBuilder.clusterAddslots(slots));
    }

    @Override
    public RedisFuture<String> clusterAddSlotsRange(Range<Integer> ... ranges) {
        return this.dispatch(this.commandBuilder.clusterAddSlotsRange(ranges));
    }

    @Override
    public RedisFuture<String> clusterBumpepoch() {
        return this.dispatch(this.commandBuilder.clusterBumpepoch());
    }

    @Override
    public RedisFuture<Long> clusterCountFailureReports(String nodeId) {
        return this.dispatch(this.commandBuilder.clusterCountFailureReports(nodeId));
    }

    @Override
    public RedisFuture<Long> clusterCountKeysInSlot(int slot) {
        return this.dispatch(this.commandBuilder.clusterCountKeysInSlot(slot));
    }

    @Override
    public RedisFuture<String> clusterDelSlots(int ... slots) {
        return this.dispatch(this.commandBuilder.clusterDelslots(slots));
    }

    @Override
    public RedisFuture<String> clusterDelSlotsRange(Range<Integer> ... ranges) {
        return this.dispatch(this.commandBuilder.clusterDelSlotsRange(ranges));
    }

    @Override
    public RedisFuture<String> clusterFailover(boolean force) {
        return this.dispatch(this.commandBuilder.clusterFailover(force));
    }

    @Override
    public RedisFuture<String> clusterFailover(boolean force, boolean takeOver) {
        return this.dispatch(this.commandBuilder.clusterFailover(force, takeOver));
    }

    @Override
    public RedisFuture<String> clusterFlushslots() {
        return this.dispatch(this.commandBuilder.clusterFlushslots());
    }

    @Override
    public RedisFuture<String> clusterForget(String nodeId) {
        return this.dispatch(this.commandBuilder.clusterForget(nodeId));
    }

    @Override
    public RedisFuture<List<K>> clusterGetKeysInSlot(int slot, int count) {
        return this.dispatch(this.commandBuilder.clusterGetKeysInSlot(slot, count));
    }

    @Override
    public RedisFuture<String> clusterInfo() {
        return this.dispatch(this.commandBuilder.clusterInfo());
    }

    @Override
    public RedisFuture<Long> clusterKeyslot(K key) {
        return this.dispatch(this.commandBuilder.clusterKeyslot(key));
    }

    @Override
    public RedisFuture<String> clusterMeet(String ip, int port) {
        return this.dispatch(this.commandBuilder.clusterMeet(ip, port));
    }

    @Override
    public RedisFuture<String> clusterMyId() {
        return this.dispatch(this.commandBuilder.clusterMyId());
    }

    @Override
    public RedisFuture<String> clusterNodes() {
        return this.dispatch(this.commandBuilder.clusterNodes());
    }

    @Override
    public RedisFuture<String> clusterReplicate(String nodeId) {
        return this.dispatch(this.commandBuilder.clusterReplicate(nodeId));
    }

    @Override
    public RedisFuture<List<String>> clusterReplicas(String nodeId) {
        return this.dispatch(this.commandBuilder.clusterReplicas(nodeId));
    }

    @Override
    public RedisFuture<String> clusterReset(boolean hard) {
        return this.dispatch(this.commandBuilder.clusterReset(hard));
    }

    @Override
    public RedisFuture<String> clusterSaveconfig() {
        return this.dispatch(this.commandBuilder.clusterSaveconfig());
    }

    @Override
    public RedisFuture<String> clusterSetConfigEpoch(long configEpoch) {
        return this.dispatch(this.commandBuilder.clusterSetConfigEpoch(configEpoch));
    }

    @Override
    public RedisFuture<String> clusterSetSlotImporting(int slot, String nodeId) {
        return this.dispatch(this.commandBuilder.clusterSetSlotImporting(slot, nodeId));
    }

    @Override
    public RedisFuture<String> clusterSetSlotMigrating(int slot, String nodeId) {
        return this.dispatch(this.commandBuilder.clusterSetSlotMigrating(slot, nodeId));
    }

    @Override
    public RedisFuture<String> clusterSetSlotNode(int slot, String nodeId) {
        return this.dispatch(this.commandBuilder.clusterSetSlotNode(slot, nodeId));
    }

    @Override
    public RedisFuture<String> clusterSetSlotStable(int slot) {
        return this.dispatch(this.commandBuilder.clusterSetSlotStable(slot));
    }

    @Override
    public RedisFuture<List<Object>> clusterShards() {
        return this.dispatch(this.commandBuilder.clusterShards());
    }

    @Override
    public RedisFuture<List<String>> clusterSlaves(String nodeId) {
        return this.dispatch(this.commandBuilder.clusterSlaves(nodeId));
    }

    @Override
    public RedisFuture<List<Object>> clusterSlots() {
        return this.dispatch(this.commandBuilder.clusterSlots());
    }

    @Override
    public RedisFuture<List<Object>> command() {
        return this.dispatch(this.commandBuilder.command());
    }

    @Override
    public RedisFuture<Long> commandCount() {
        return this.dispatch(this.commandBuilder.commandCount());
    }

    @Override
    public RedisFuture<List<Object>> commandInfo(String ... commands) {
        return this.dispatch(this.commandBuilder.commandInfo(commands));
    }

    @Override
    public RedisFuture<List<Object>> commandInfo(CommandType ... commands) {
        String[] stringCommands = new String[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            stringCommands[i] = commands[i].name();
        }
        return this.commandInfo(stringCommands);
    }

    @Override
    public RedisFuture<Map<String, String>> configGet(String parameter) {
        return this.dispatch(this.commandBuilder.configGet(parameter));
    }

    @Override
    public RedisFuture<Map<String, String>> configGet(String ... parameters) {
        return this.dispatch(this.commandBuilder.configGet(parameters));
    }

    @Override
    public RedisFuture<String> configResetstat() {
        return this.dispatch(this.commandBuilder.configResetstat());
    }

    @Override
    public RedisFuture<String> configRewrite() {
        return this.dispatch(this.commandBuilder.configRewrite());
    }

    @Override
    public RedisFuture<String> configSet(String parameter, String value) {
        return this.dispatch(this.commandBuilder.configSet(parameter, value));
    }

    @Override
    public RedisFuture<String> configSet(Map<String, String> kvs) {
        return this.dispatch(this.commandBuilder.configSet(kvs));
    }

    @Override
    public RedisFuture<Long> dbsize() {
        return this.dispatch(this.commandBuilder.dbsize());
    }

    @Override
    public RedisFuture<String> debugCrashAndRecover(Long delay) {
        return this.dispatch(this.commandBuilder.debugCrashAndRecover(delay));
    }

    @Override
    public RedisFuture<String> debugHtstats(int db) {
        return this.dispatch(this.commandBuilder.debugHtstats(db));
    }

    @Override
    public RedisFuture<String> debugObject(K key) {
        return this.dispatch(this.commandBuilder.debugObject(key));
    }

    @Override
    public void debugOom() {
        this.dispatch(this.commandBuilder.debugOom());
    }

    @Override
    public RedisFuture<String> debugReload() {
        return this.dispatch(this.commandBuilder.debugReload());
    }

    @Override
    public RedisFuture<String> debugRestart(Long delay) {
        return this.dispatch(this.commandBuilder.debugRestart(delay));
    }

    @Override
    public RedisFuture<String> debugSdslen(K key) {
        return this.dispatch(this.commandBuilder.debugSdslen(key));
    }

    @Override
    public void debugSegfault() {
        this.dispatch(this.commandBuilder.debugSegfault());
    }

    @Override
    public RedisFuture<Long> decr(K key) {
        return this.dispatch(this.commandBuilder.decr(key));
    }

    @Override
    public RedisFuture<Long> decrby(K key, long amount) {
        return this.dispatch(this.commandBuilder.decrby(key, amount));
    }

    @Override
    public RedisFuture<Long> del(K ... keys2) {
        return this.dispatch(this.commandBuilder.del(keys2));
    }

    public RedisFuture<Long> del(Iterable<K> keys2) {
        return this.dispatch(this.commandBuilder.del(keys2));
    }

    @Override
    public String digest(String script) {
        return this.digest(this.encodeScript(script));
    }

    @Override
    public String digest(byte[] script) {
        return Base16.digest(script);
    }

    @Override
    public RedisFuture<String> discard() {
        return this.dispatch(this.commandBuilder.discard());
    }

    @Override
    public <T> RedisFuture<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        return this.dispatch(new AsyncCommand<K, V, T>(new Command<K, V, T>(type, output)));
    }

    @Override
    public <T> RedisFuture<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args2) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        LettuceAssert.notNull(args2, "CommandArgs type must not be null");
        return this.dispatch(new AsyncCommand<K, V, T>(new Command<K, V, T>(type, output, args2)));
    }

    protected <T> RedisFuture<T> dispatch(CommandType type, CommandOutput<K, V, T> output) {
        return this.dispatch(type, output, null);
    }

    protected <T> RedisFuture<T> dispatch(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args2) {
        return this.dispatch(new AsyncCommand<K, V, T>(new Command<K, V, T>(type, output, args2)));
    }

    public <T> AsyncCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        AsyncCommand<K, V, T> asyncCommand = new AsyncCommand<K, V, T>(cmd);
        RedisCommand<K, V, T> dispatched = this.connection.dispatch(asyncCommand);
        if (dispatched instanceof AsyncCommand) {
            return (AsyncCommand)dispatched;
        }
        return asyncCommand;
    }

    @Override
    public RedisFuture<byte[]> dump(K key) {
        return this.dispatch(this.commandBuilder.dump(key));
    }

    @Override
    public RedisFuture<V> echo(V msg) {
        return this.dispatch(this.commandBuilder.echo(msg));
    }

    @Override
    public <T> RedisFuture<T> eval(String script, ScriptOutputType type, K ... keys2) {
        return this.eval(this.encodeScript(script), type, keys2);
    }

    @Override
    public <T> RedisFuture<T> eval(byte[] script, ScriptOutputType type, K ... keys2) {
        return this.dispatch(this.commandBuilder.eval(script, type, keys2, new Object[0]));
    }

    @Override
    public <T> RedisFuture<T> eval(String script, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.eval(this.encodeScript(script), type, keys2, values2);
    }

    @Override
    public <T> RedisFuture<T> eval(byte[] script, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.dispatch(this.commandBuilder.eval(script, type, keys2, values2));
    }

    @Override
    public <T> RedisFuture<T> evalReadOnly(byte[] script, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.dispatch(this.commandBuilder.eval(script, type, true, keys2, values2));
    }

    @Override
    public <T> RedisFuture<T> evalsha(String digest, ScriptOutputType type, K ... keys2) {
        return this.dispatch(this.commandBuilder.evalsha(digest, type, keys2, new Object[0]));
    }

    @Override
    public <T> RedisFuture<T> evalsha(String digest, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.dispatch(this.commandBuilder.evalsha(digest, type, keys2, values2));
    }

    @Override
    public <T> RedisFuture<T> evalshaReadOnly(String digest, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.dispatch(this.commandBuilder.evalsha(digest, type, true, keys2, values2));
    }

    @Override
    public RedisFuture<TransactionResult> exec() {
        return this.dispatch(CommandType.EXEC, null);
    }

    @Override
    public RedisFuture<Long> exists(K ... keys2) {
        return this.dispatch(this.commandBuilder.exists(keys2));
    }

    public RedisFuture<Long> exists(Iterable<K> keys2) {
        return this.dispatch(this.commandBuilder.exists(keys2));
    }

    @Override
    public RedisFuture<Boolean> expire(K key, long seconds) {
        return this.expire(key, seconds, null);
    }

    @Override
    public RedisFuture<Boolean> expire(K key, long seconds, ExpireArgs expireArgs) {
        return this.dispatch(this.commandBuilder.expire(key, seconds, expireArgs));
    }

    @Override
    public RedisFuture<Boolean> expire(K key, Duration seconds) {
        return this.expire(key, seconds, null);
    }

    @Override
    public RedisFuture<Boolean> expire(K key, Duration seconds, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)seconds, "Timeout must not be null");
        return this.expire(key, seconds.toMillis() / 1000L, expireArgs);
    }

    @Override
    public RedisFuture<Boolean> expireat(K key, long timestamp) {
        return this.expireat(key, timestamp, null);
    }

    @Override
    public RedisFuture<Boolean> expireat(K key, long timestamp, ExpireArgs expireArgs) {
        return this.dispatch(this.commandBuilder.expireat(key, timestamp, expireArgs));
    }

    @Override
    public RedisFuture<Boolean> expireat(K key, Date timestamp) {
        return this.expireat(key, timestamp, null);
    }

    @Override
    public RedisFuture<Boolean> expireat(K key, Date timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.expireat(key, timestamp.getTime() / 1000L, expireArgs);
    }

    @Override
    public RedisFuture<Boolean> expireat(K key, Instant timestamp) {
        return this.expireat(key, timestamp, null);
    }

    @Override
    public RedisFuture<Boolean> expireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.expireat(key, timestamp.toEpochMilli() / 1000L, expireArgs);
    }

    @Override
    public RedisFuture<Long> expiretime(K key) {
        return this.dispatch(this.commandBuilder.expiretime(key));
    }

    @Override
    public <T> RedisFuture<T> fcall(String function, ScriptOutputType type, K ... keys2) {
        return this.dispatch(this.commandBuilder.fcall(function, type, false, keys2, new Object[0]));
    }

    @Override
    public <T> RedisFuture<T> fcall(String function, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.dispatch(this.commandBuilder.fcall(function, type, false, keys2, values2));
    }

    @Override
    public <T> RedisFuture<T> fcallReadOnly(String function, ScriptOutputType type, K ... keys2) {
        return this.dispatch(this.commandBuilder.fcall(function, type, true, keys2, new Object[0]));
    }

    @Override
    public <T> RedisFuture<T> fcallReadOnly(String function, ScriptOutputType type, K[] keys2, V ... values2) {
        return this.dispatch(this.commandBuilder.fcall(function, type, true, keys2, values2));
    }

    @Override
    public RedisFuture<String> functionLoad(String functionCode) {
        return this.functionLoad(functionCode, false);
    }

    @Override
    public RedisFuture<String> functionLoad(String functionCode, boolean replace) {
        return this.dispatch(this.commandBuilder.functionLoad(this.encodeFunction(functionCode), replace));
    }

    @Override
    public RedisFuture<byte[]> functionDump() {
        return this.dispatch(this.commandBuilder.functionDump());
    }

    @Override
    public RedisFuture<String> functionRestore(byte[] dump) {
        return this.functionRestore(dump, null);
    }

    @Override
    public RedisFuture<String> functionRestore(byte[] dump, FunctionRestoreMode mode) {
        return this.dispatch(this.commandBuilder.functionRestore(dump, mode));
    }

    @Override
    public RedisFuture<String> functionFlush(FlushMode flushMode) {
        return this.dispatch(this.commandBuilder.functionFlush(flushMode));
    }

    @Override
    public RedisFuture<String> functionKill() {
        return this.dispatch(this.commandBuilder.functionKill());
    }

    @Override
    public RedisFuture<List<Map<String, Object>>> functionList() {
        return this.functionList(null);
    }

    @Override
    public RedisFuture<List<Map<String, Object>>> functionList(String libraryName) {
        return this.dispatch(this.commandBuilder.functionList(libraryName));
    }

    @Override
    public void flushCommands() {
        this.connection.flushCommands();
    }

    @Override
    public RedisFuture<String> flushall() {
        return this.dispatch(this.commandBuilder.flushall());
    }

    @Override
    public RedisFuture<String> flushall(FlushMode flushMode) {
        return this.dispatch(this.commandBuilder.flushall(flushMode));
    }

    @Override
    public RedisFuture<String> flushallAsync() {
        return this.flushall(FlushMode.ASYNC);
    }

    @Override
    public RedisFuture<String> flushdb() {
        return this.dispatch(this.commandBuilder.flushdb());
    }

    @Override
    public RedisFuture<String> flushdb(FlushMode flushMode) {
        return this.dispatch(this.commandBuilder.flushdb(flushMode));
    }

    @Override
    public RedisFuture<String> flushdbAsync() {
        return this.flushdb(FlushMode.ASYNC);
    }

    @Override
    public RedisFuture<Long> geoadd(K key, double longitude, double latitude, V member) {
        return this.geoadd(key, longitude, latitude, member, null);
    }

    @Override
    public RedisFuture<Long> geoadd(K key, double longitude, double latitude, V member, GeoAddArgs args2) {
        return this.dispatch(this.commandBuilder.geoadd(key, longitude, latitude, member, args2));
    }

    @Override
    public RedisFuture<Long> geoadd(K key, Object ... lngLatMember) {
        return this.geoadd(key, null, lngLatMember);
    }

    @Override
    public RedisFuture<Long> geoadd(K key, GeoValue<V> ... values2) {
        return this.dispatch(this.commandBuilder.geoadd(key, values2, (GeoAddArgs)null));
    }

    @Override
    public RedisFuture<Long> geoadd(K key, GeoAddArgs args2, Object ... lngLatMember) {
        return this.dispatch(this.commandBuilder.geoadd(key, lngLatMember, args2));
    }

    @Override
    public RedisFuture<Long> geoadd(K key, GeoAddArgs args2, GeoValue<V> ... values2) {
        return this.dispatch(this.commandBuilder.geoadd(key, values2, args2));
    }

    @Override
    public RedisFuture<Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        return this.dispatch(this.commandBuilder.geodist(key, from, to, unit));
    }

    @Override
    public RedisFuture<List<Value<String>>> geohash(K key, V ... members) {
        return this.dispatch(this.commandBuilder.geohash(key, members));
    }

    @Override
    public RedisFuture<List<GeoCoordinates>> geopos(K key, V ... members) {
        return this.dispatch(this.commandBuilder.geopos(key, members));
    }

    @Override
    public RedisFuture<Set<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return this.dispatch(this.commandBuilder.georadius(CommandType.GEORADIUS, key, longitude, latitude, distance, unit.name()));
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.dispatch(this.commandBuilder.georadius(CommandType.GEORADIUS, key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public RedisFuture<Long> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return this.dispatch(this.commandBuilder.georadius(key, longitude, latitude, distance, unit.name(), geoRadiusStoreArgs));
    }

    protected RedisFuture<Set<V>> georadius_ro(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return this.dispatch(this.commandBuilder.georadius(CommandType.GEORADIUS_RO, key, longitude, latitude, distance, unit.name()));
    }

    protected RedisFuture<List<GeoWithin<V>>> georadius_ro(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.dispatch(this.commandBuilder.georadius(CommandType.GEORADIUS_RO, key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public RedisFuture<Set<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return this.dispatch(this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER, key, member, distance, unit.name()));
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.dispatch(this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER, key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public RedisFuture<Long> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return this.dispatch(this.commandBuilder.georadiusbymember(key, member, distance, unit.name(), geoRadiusStoreArgs));
    }

    protected RedisFuture<Set<V>> georadiusbymember_ro(K key, V member, double distance, GeoArgs.Unit unit) {
        return this.dispatch(this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER_RO, key, member, distance, unit.name()));
    }

    protected RedisFuture<List<GeoWithin<V>>> georadiusbymember_ro(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.dispatch(this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER_RO, key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public RedisFuture<Set<V>> geosearch(K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate) {
        return this.dispatch(this.commandBuilder.geosearch(key, reference, predicate));
    }

    @Override
    public RedisFuture<List<GeoWithin<V>>> geosearch(K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate, GeoArgs geoArgs) {
        return this.dispatch(this.commandBuilder.geosearch(key, reference, predicate, geoArgs));
    }

    @Override
    public RedisFuture<Long> geosearchstore(K destination, K key, GeoSearch.GeoRef<K> reference, GeoSearch.GeoPredicate predicate, GeoArgs geoArgs, boolean storeDist) {
        return this.dispatch(this.commandBuilder.geosearchstore(destination, key, reference, predicate, geoArgs, storeDist));
    }

    @Override
    public RedisFuture<V> get(K key) {
        return this.dispatch(this.commandBuilder.get(key));
    }

    public StatefulConnection<K, V> getConnection() {
        return this.connection;
    }

    @Override
    public RedisFuture<Long> getbit(K key, long offset) {
        return this.dispatch(this.commandBuilder.getbit(key, offset));
    }

    @Override
    public RedisFuture<V> getdel(K key) {
        return this.dispatch(this.commandBuilder.getdel(key));
    }

    @Override
    public RedisFuture<V> getex(K key, GetExArgs args2) {
        return this.dispatch(this.commandBuilder.getex(key, args2));
    }

    @Override
    public RedisFuture<V> getrange(K key, long start, long end) {
        return this.dispatch(this.commandBuilder.getrange(key, start, end));
    }

    @Override
    public RedisFuture<V> getset(K key, V value) {
        return this.dispatch(this.commandBuilder.getset(key, value));
    }

    @Override
    public RedisFuture<Long> hdel(K key, K ... fields) {
        return this.dispatch(this.commandBuilder.hdel(key, fields));
    }

    @Override
    public RedisFuture<Boolean> hexists(K key, K field) {
        return this.dispatch(this.commandBuilder.hexists(key, field));
    }

    @Override
    public RedisFuture<V> hget(K key, K field) {
        return this.dispatch(this.commandBuilder.hget(key, field));
    }

    @Override
    public RedisFuture<Map<K, V>> hgetall(K key) {
        return this.dispatch(this.commandBuilder.hgetall(key));
    }

    @Override
    public RedisFuture<Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.dispatch(this.commandBuilder.hgetall(channel, key));
    }

    @Override
    public RedisFuture<Long> hincrby(K key, K field, long amount) {
        return this.dispatch(this.commandBuilder.hincrby(key, field, amount));
    }

    @Override
    public RedisFuture<Double> hincrbyfloat(K key, K field, double amount) {
        return this.dispatch(this.commandBuilder.hincrbyfloat(key, field, amount));
    }

    @Override
    public RedisFuture<List<K>> hkeys(K key) {
        return this.dispatch(this.commandBuilder.hkeys(key));
    }

    @Override
    public RedisFuture<Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        return this.dispatch(this.commandBuilder.hkeys(channel, key));
    }

    @Override
    public RedisFuture<Long> hlen(K key) {
        return this.dispatch(this.commandBuilder.hlen(key));
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> hmget(K key, K ... fields) {
        return this.dispatch(this.commandBuilder.hmgetKeyValue(key, fields));
    }

    @Override
    public RedisFuture<Long> hmget(KeyValueStreamingChannel<K, V> channel, K key, K ... fields) {
        return this.dispatch(this.commandBuilder.hmget(channel, key, fields));
    }

    @Override
    public RedisFuture<String> hmset(K key, Map<K, V> map) {
        return this.dispatch(this.commandBuilder.hmset(key, map));
    }

    @Override
    public RedisFuture<K> hrandfield(K key) {
        return this.dispatch(this.commandBuilder.hrandfield(key));
    }

    @Override
    public RedisFuture<List<K>> hrandfield(K key, long count) {
        return this.dispatch(this.commandBuilder.hrandfield(key, count));
    }

    @Override
    public RedisFuture<KeyValue<K, V>> hrandfieldWithvalues(K key) {
        return this.dispatch(this.commandBuilder.hrandfieldWithvalues(key));
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> hrandfieldWithvalues(K key, long count) {
        return this.dispatch(this.commandBuilder.hrandfieldWithvalues(key, count));
    }

    @Override
    public RedisFuture<MapScanCursor<K, V>> hscan(K key) {
        return this.dispatch(this.commandBuilder.hscan(key));
    }

    @Override
    public RedisFuture<MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.hscan(key, scanArgs));
    }

    @Override
    public RedisFuture<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.hscan(key, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.hscan(key, scanCursor));
    }

    @Override
    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.dispatch(this.commandBuilder.hscanStreaming(channel, key));
    }

    @Override
    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.hscanStreaming(channel, key, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.hscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.hscanStreaming(channel, key, scanCursor));
    }

    @Override
    public RedisFuture<Boolean> hset(K key, K field, V value) {
        return this.dispatch(this.commandBuilder.hset(key, field, value));
    }

    @Override
    public RedisFuture<Long> hset(K key, Map<K, V> map) {
        return this.dispatch(this.commandBuilder.hset(key, map));
    }

    @Override
    public RedisFuture<Boolean> hsetnx(K key, K field, V value) {
        return this.dispatch(this.commandBuilder.hsetnx(key, field, value));
    }

    @Override
    public RedisFuture<Long> hstrlen(K key, K field) {
        return this.dispatch(this.commandBuilder.hstrlen(key, field));
    }

    @Override
    public RedisFuture<List<V>> hvals(K key) {
        return this.dispatch(this.commandBuilder.hvals(key));
    }

    @Override
    public RedisFuture<Long> hvals(ValueStreamingChannel<V> channel, K key) {
        return this.dispatch(this.commandBuilder.hvals(channel, key));
    }

    @Override
    public RedisFuture<Long> incr(K key) {
        return this.dispatch(this.commandBuilder.incr(key));
    }

    @Override
    public RedisFuture<Long> incrby(K key, long amount) {
        return this.dispatch(this.commandBuilder.incrby(key, amount));
    }

    @Override
    public RedisFuture<Double> incrbyfloat(K key, double amount) {
        return this.dispatch(this.commandBuilder.incrbyfloat(key, amount));
    }

    @Override
    public RedisFuture<String> info() {
        return this.dispatch(this.commandBuilder.info());
    }

    @Override
    public RedisFuture<String> info(String section) {
        return this.dispatch(this.commandBuilder.info(section));
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public RedisFuture<List<K>> keys(K pattern) {
        return this.dispatch(this.commandBuilder.keys(pattern));
    }

    @Override
    public RedisFuture<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        return this.dispatch(this.commandBuilder.keys(channel, pattern));
    }

    @Override
    public RedisFuture<Date> lastsave() {
        return this.dispatch(this.commandBuilder.lastsave());
    }

    @Override
    public RedisFuture<V> lindex(K key, long index) {
        return this.dispatch(this.commandBuilder.lindex(key, index));
    }

    @Override
    public RedisFuture<Long> linsert(K key, boolean before, V pivot, V value) {
        return this.dispatch(this.commandBuilder.linsert(key, before, pivot, value));
    }

    @Override
    public RedisFuture<Long> llen(K key) {
        return this.dispatch(this.commandBuilder.llen(key));
    }

    @Override
    public RedisFuture<V> lmove(K source2, K destination, LMoveArgs args2) {
        return this.dispatch(this.commandBuilder.lmove(source2, destination, args2));
    }

    @Override
    public RedisFuture<V> lpop(K key) {
        return this.dispatch(this.commandBuilder.lpop(key));
    }

    @Override
    public RedisFuture<List<V>> lpop(K key, long count) {
        return this.dispatch(this.commandBuilder.lpop(key, count));
    }

    @Override
    public RedisFuture<KeyValue<K, List<V>>> lmpop(LMPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.lmpop(args2, keys2));
    }

    @Override
    public RedisFuture<Long> lpos(K key, V value) {
        return this.lpos(key, value, null);
    }

    @Override
    public RedisFuture<Long> lpos(K key, V value, LPosArgs args2) {
        return this.dispatch(this.commandBuilder.lpos(key, value, args2));
    }

    @Override
    public RedisFuture<List<Long>> lpos(K key, V value, int count) {
        return this.lpos(key, value, count, null);
    }

    @Override
    public RedisFuture<List<Long>> lpos(K key, V value, int count, LPosArgs args2) {
        return this.dispatch(this.commandBuilder.lpos(key, value, count, args2));
    }

    @Override
    public RedisFuture<Long> lpush(K key, V ... values2) {
        return this.dispatch(this.commandBuilder.lpush(key, values2));
    }

    @Override
    public RedisFuture<Long> lpushx(K key, V ... values2) {
        return this.dispatch(this.commandBuilder.lpushx(key, values2));
    }

    @Override
    public RedisFuture<List<V>> lrange(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.lrange(key, start, stop));
    }

    @Override
    public RedisFuture<Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.lrange(channel, key, start, stop));
    }

    @Override
    public RedisFuture<Long> lrem(K key, long count, V value) {
        return this.dispatch(this.commandBuilder.lrem(key, count, value));
    }

    @Override
    public RedisFuture<String> lset(K key, long index, V value) {
        return this.dispatch(this.commandBuilder.lset(key, index, value));
    }

    @Override
    public RedisFuture<String> ltrim(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.ltrim(key, start, stop));
    }

    @Override
    public RedisFuture<Long> memoryUsage(K key) {
        return this.dispatch(this.commandBuilder.memoryUsage(key));
    }

    @Override
    public RedisFuture<List<KeyValue<K, V>>> mget(K ... keys2) {
        return this.dispatch(this.commandBuilder.mgetKeyValue(keys2));
    }

    public RedisFuture<List<KeyValue<K, V>>> mget(Iterable<K> keys2) {
        return this.dispatch(this.commandBuilder.mgetKeyValue(keys2));
    }

    @Override
    public RedisFuture<Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys2) {
        return this.dispatch(this.commandBuilder.mget(channel, keys2));
    }

    public RedisFuture<Long> mget(KeyValueStreamingChannel<K, V> channel, Iterable<K> keys2) {
        return this.dispatch(this.commandBuilder.mget(channel, keys2));
    }

    @Override
    public RedisFuture<String> migrate(String host, int port, K key, int db, long timeout2) {
        return this.dispatch(this.commandBuilder.migrate(host, port, key, db, timeout2));
    }

    @Override
    public RedisFuture<String> migrate(String host, int port, int db, long timeout2, MigrateArgs<K> migrateArgs) {
        return this.dispatch(this.commandBuilder.migrate(host, port, db, timeout2, migrateArgs));
    }

    @Override
    public RedisFuture<Boolean> move(K key, int db) {
        return this.dispatch(this.commandBuilder.move(key, db));
    }

    @Override
    public RedisFuture<String> mset(Map<K, V> map) {
        return this.dispatch(this.commandBuilder.mset(map));
    }

    @Override
    public RedisFuture<Boolean> msetnx(Map<K, V> map) {
        return this.dispatch(this.commandBuilder.msetnx(map));
    }

    @Override
    public RedisFuture<String> multi() {
        return this.dispatch(this.commandBuilder.multi());
    }

    @Override
    public RedisFuture<String> objectEncoding(K key) {
        return this.dispatch(this.commandBuilder.objectEncoding(key));
    }

    @Override
    public RedisFuture<Long> objectFreq(K key) {
        return this.dispatch(this.commandBuilder.objectFreq(key));
    }

    @Override
    public RedisFuture<Long> objectIdletime(K key) {
        return this.dispatch(this.commandBuilder.objectIdletime(key));
    }

    @Override
    public RedisFuture<Long> objectRefcount(K key) {
        return this.dispatch(this.commandBuilder.objectRefcount(key));
    }

    @Override
    public RedisFuture<Boolean> persist(K key) {
        return this.dispatch(this.commandBuilder.persist(key));
    }

    @Override
    public RedisFuture<Boolean> pexpire(K key, long milliseconds) {
        return this.pexpire(key, milliseconds, null);
    }

    @Override
    public RedisFuture<Boolean> pexpire(K key, long milliseconds, ExpireArgs expireArgs) {
        return this.dispatch(this.commandBuilder.pexpire(key, milliseconds, expireArgs));
    }

    @Override
    public RedisFuture<Boolean> pexpire(K key, Duration milliseconds) {
        return this.pexpire(key, milliseconds, null);
    }

    @Override
    public RedisFuture<Boolean> pexpire(K key, Duration milliseconds, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)milliseconds, "Timeout must not be null");
        return this.pexpire(key, milliseconds.toMillis(), expireArgs);
    }

    @Override
    public RedisFuture<Boolean> pexpireat(K key, Date timestamp) {
        return this.pexpireat(key, timestamp, null);
    }

    @Override
    public RedisFuture<Boolean> pexpireat(K key, Date timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pexpireat(key, timestamp.getTime(), expireArgs);
    }

    @Override
    public RedisFuture<Boolean> pexpireat(K key, Instant timestamp) {
        return this.pexpireat(key, timestamp, null);
    }

    @Override
    public RedisFuture<Boolean> pexpireat(K key, Instant timestamp, ExpireArgs expireArgs) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.pexpireat(key, timestamp.toEpochMilli(), expireArgs);
    }

    @Override
    public RedisFuture<Boolean> pexpireat(K key, long timestamp) {
        return this.pexpireat(key, timestamp, null);
    }

    @Override
    public RedisFuture<Boolean> pexpireat(K key, long timestamp, ExpireArgs expireArgs) {
        return this.dispatch(this.commandBuilder.pexpireat(key, timestamp, expireArgs));
    }

    @Override
    public RedisFuture<Long> pexpiretime(K key) {
        return this.dispatch(this.commandBuilder.pexpiretime(key));
    }

    @Override
    public RedisFuture<Long> pfadd(K key, V ... values2) {
        return this.dispatch(this.commandBuilder.pfadd(key, values2));
    }

    @Override
    public RedisFuture<Long> pfcount(K ... keys2) {
        return this.dispatch(this.commandBuilder.pfcount(keys2));
    }

    @Override
    public RedisFuture<String> pfmerge(K destkey, K ... sourcekeys) {
        return this.dispatch(this.commandBuilder.pfmerge(destkey, sourcekeys));
    }

    @Override
    public RedisFuture<String> ping() {
        return this.dispatch(this.commandBuilder.ping());
    }

    @Override
    public RedisFuture<String> psetex(K key, long milliseconds, V value) {
        return this.dispatch(this.commandBuilder.psetex(key, milliseconds, value));
    }

    @Override
    public RedisFuture<Long> pttl(K key) {
        return this.dispatch(this.commandBuilder.pttl(key));
    }

    @Override
    public RedisFuture<Long> publish(K channel, V message) {
        return this.dispatch(this.commandBuilder.publish(channel, message));
    }

    @Override
    public RedisFuture<List<K>> pubsubChannels() {
        return this.dispatch(this.commandBuilder.pubsubChannels());
    }

    @Override
    public RedisFuture<List<K>> pubsubChannels(K channel) {
        return this.dispatch(this.commandBuilder.pubsubChannels(channel));
    }

    @Override
    public RedisFuture<Long> pubsubNumpat() {
        return this.dispatch(this.commandBuilder.pubsubNumpat());
    }

    @Override
    public RedisFuture<Map<K, Long>> pubsubNumsub(K ... channels) {
        return this.dispatch(this.commandBuilder.pubsubNumsub(channels));
    }

    @Override
    public RedisFuture<String> quit() {
        return this.dispatch(this.commandBuilder.quit());
    }

    @Override
    public RedisFuture<K> randomkey() {
        return this.dispatch(this.commandBuilder.randomkey());
    }

    @Override
    public RedisFuture<String> readOnly() {
        return this.dispatch(this.commandBuilder.readOnly());
    }

    @Override
    public RedisFuture<String> readWrite() {
        return this.dispatch(this.commandBuilder.readWrite());
    }

    @Override
    public RedisFuture<String> rename(K key, K newKey) {
        return this.dispatch(this.commandBuilder.rename(key, newKey));
    }

    @Override
    public RedisFuture<Boolean> renamenx(K key, K newKey) {
        return this.dispatch(this.commandBuilder.renamenx(key, newKey));
    }

    @Override
    public RedisFuture<String> replicaof(String host, int port) {
        return this.dispatch(this.commandBuilder.replicaof(host, port));
    }

    @Override
    public RedisFuture<String> replicaofNoOne() {
        return this.dispatch(this.commandBuilder.replicaofNoOne());
    }

    @Override
    public void reset() {
        this.getConnection().reset();
    }

    @Override
    public RedisFuture<String> restore(K key, long ttl, byte[] value) {
        return this.dispatch(this.commandBuilder.restore(key, value, RestoreArgs.Builder.ttl(ttl)));
    }

    @Override
    public RedisFuture<String> restore(K key, byte[] value, RestoreArgs args2) {
        return this.dispatch(this.commandBuilder.restore(key, value, args2));
    }

    @Override
    public RedisFuture<List<Object>> role() {
        return this.dispatch(this.commandBuilder.role());
    }

    @Override
    public RedisFuture<V> rpop(K key) {
        return this.dispatch(this.commandBuilder.rpop(key));
    }

    @Override
    public RedisFuture<List<V>> rpop(K key, long count) {
        return this.dispatch(this.commandBuilder.rpop(key, count));
    }

    @Override
    public RedisFuture<V> rpoplpush(K source2, K destination) {
        return this.dispatch(this.commandBuilder.rpoplpush(source2, destination));
    }

    @Override
    public RedisFuture<Long> rpush(K key, V ... values2) {
        return this.dispatch(this.commandBuilder.rpush(key, values2));
    }

    @Override
    public RedisFuture<Long> rpushx(K key, V ... values2) {
        return this.dispatch(this.commandBuilder.rpushx(key, values2));
    }

    @Override
    public RedisFuture<Long> sadd(K key, V ... members) {
        return this.dispatch(this.commandBuilder.sadd(key, members));
    }

    @Override
    public RedisFuture<String> save() {
        return this.dispatch(this.commandBuilder.save());
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan() {
        return this.dispatch(this.commandBuilder.scan());
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.scan(scanArgs));
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.scan(scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.scan(scanCursor));
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.dispatch(this.commandBuilder.scanStreaming(channel));
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.scanStreaming(channel, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.scanStreaming(channel, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.scanStreaming(channel, scanCursor));
    }

    @Override
    public RedisFuture<Long> scard(K key) {
        return this.dispatch(this.commandBuilder.scard(key));
    }

    @Override
    public RedisFuture<List<Boolean>> scriptExists(String ... digests) {
        return this.dispatch(this.commandBuilder.scriptExists(digests));
    }

    @Override
    public RedisFuture<String> scriptFlush() {
        return this.dispatch(this.commandBuilder.scriptFlush());
    }

    @Override
    public RedisFuture<String> scriptFlush(FlushMode flushMode) {
        return this.dispatch(this.commandBuilder.scriptFlush(flushMode));
    }

    @Override
    public RedisFuture<String> scriptKill() {
        return this.dispatch(this.commandBuilder.scriptKill());
    }

    @Override
    public RedisFuture<String> scriptLoad(String script) {
        return this.scriptLoad(this.encodeScript(script));
    }

    @Override
    public RedisFuture<String> scriptLoad(byte[] script) {
        return this.dispatch(this.commandBuilder.scriptLoad(script));
    }

    @Override
    public RedisFuture<Set<V>> sdiff(K ... keys2) {
        return this.dispatch(this.commandBuilder.sdiff(keys2));
    }

    @Override
    public RedisFuture<Long> sdiff(ValueStreamingChannel<V> channel, K ... keys2) {
        return this.dispatch(this.commandBuilder.sdiff(channel, keys2));
    }

    @Override
    public RedisFuture<Long> sdiffstore(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.sdiffstore(destination, keys2));
    }

    public RedisFuture<String> select(int db) {
        return this.dispatch(this.commandBuilder.select(db));
    }

    @Override
    public RedisFuture<String> set(K key, V value) {
        return this.dispatch(this.commandBuilder.set(key, value));
    }

    @Override
    public RedisFuture<String> set(K key, V value, SetArgs setArgs) {
        return this.dispatch(this.commandBuilder.set(key, value, setArgs));
    }

    @Override
    public RedisFuture<V> setGet(K key, V value) {
        return this.dispatch(this.commandBuilder.setGet(key, value));
    }

    @Override
    public RedisFuture<V> setGet(K key, V value, SetArgs setArgs) {
        return this.dispatch(this.commandBuilder.setGet(key, value, setArgs));
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.connection.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void setTimeout(Duration timeout2) {
        this.connection.setTimeout(timeout2);
    }

    @Override
    public RedisFuture<Long> setbit(K key, long offset, int value) {
        return this.dispatch(this.commandBuilder.setbit(key, offset, value));
    }

    @Override
    public RedisFuture<String> setex(K key, long seconds, V value) {
        return this.dispatch(this.commandBuilder.setex(key, seconds, value));
    }

    @Override
    public RedisFuture<Boolean> setnx(K key, V value) {
        return this.dispatch(this.commandBuilder.setnx(key, value));
    }

    @Override
    public RedisFuture<Long> setrange(K key, long offset, V value) {
        return this.dispatch(this.commandBuilder.setrange(key, offset, value));
    }

    @Override
    public void shutdown(boolean save) {
        this.dispatch(this.commandBuilder.shutdown(save));
    }

    @Override
    public void shutdown(ShutdownArgs args2) {
        this.dispatch(this.commandBuilder.shutdown(args2));
    }

    @Override
    public RedisFuture<Set<V>> sinter(K ... keys2) {
        return this.dispatch(this.commandBuilder.sinter(keys2));
    }

    @Override
    public RedisFuture<Long> sinter(ValueStreamingChannel<V> channel, K ... keys2) {
        return this.dispatch(this.commandBuilder.sinter(channel, keys2));
    }

    @Override
    public RedisFuture<Long> sintercard(K ... keys2) {
        return this.dispatch(this.commandBuilder.sintercard(keys2));
    }

    @Override
    public RedisFuture<Long> sintercard(long limit, K ... keys2) {
        return this.dispatch(this.commandBuilder.sintercard(limit, keys2));
    }

    @Override
    public RedisFuture<Long> sinterstore(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.sinterstore(destination, keys2));
    }

    @Override
    public RedisFuture<Boolean> sismember(K key, V member) {
        return this.dispatch(this.commandBuilder.sismember(key, member));
    }

    @Override
    public RedisFuture<String> slaveof(String host, int port) {
        return this.dispatch(this.commandBuilder.slaveof(host, port));
    }

    @Override
    public RedisFuture<String> slaveofNoOne() {
        return this.dispatch(this.commandBuilder.slaveofNoOne());
    }

    @Override
    public RedisFuture<List<Object>> slowlogGet() {
        return this.dispatch(this.commandBuilder.slowlogGet());
    }

    @Override
    public RedisFuture<List<Object>> slowlogGet(int count) {
        return this.dispatch(this.commandBuilder.slowlogGet(count));
    }

    @Override
    public RedisFuture<Long> slowlogLen() {
        return this.dispatch(this.commandBuilder.slowlogLen());
    }

    @Override
    public RedisFuture<String> slowlogReset() {
        return this.dispatch(this.commandBuilder.slowlogReset());
    }

    @Override
    public RedisFuture<Set<V>> smembers(K key) {
        return this.dispatch(this.commandBuilder.smembers(key));
    }

    @Override
    public RedisFuture<Long> smembers(ValueStreamingChannel<V> channel, K key) {
        return this.dispatch(this.commandBuilder.smembers(channel, key));
    }

    @Override
    public RedisFuture<List<Boolean>> smismember(K key, V ... members) {
        return this.dispatch(this.commandBuilder.smismember(key, members));
    }

    @Override
    public RedisFuture<Boolean> smove(K source2, K destination, V member) {
        return this.dispatch(this.commandBuilder.smove(source2, destination, member));
    }

    @Override
    public RedisFuture<List<V>> sort(K key) {
        return this.dispatch(this.commandBuilder.sort(key));
    }

    @Override
    public RedisFuture<Long> sort(ValueStreamingChannel<V> channel, K key) {
        return this.dispatch(this.commandBuilder.sort(channel, key));
    }

    @Override
    public RedisFuture<List<V>> sort(K key, SortArgs sortArgs) {
        return this.dispatch(this.commandBuilder.sort(key, sortArgs));
    }

    @Override
    public RedisFuture<Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        return this.dispatch(this.commandBuilder.sortReadOnly(channel, key, sortArgs));
    }

    @Override
    public RedisFuture<List<V>> sortReadOnly(K key) {
        return this.dispatch(this.commandBuilder.sortReadOnly(key));
    }

    @Override
    public RedisFuture<Long> sortReadOnly(ValueStreamingChannel<V> channel, K key) {
        return this.dispatch(this.commandBuilder.sortReadOnly(channel, key));
    }

    @Override
    public RedisFuture<List<V>> sortReadOnly(K key, SortArgs sortArgs) {
        return this.dispatch(this.commandBuilder.sortReadOnly(key, sortArgs));
    }

    @Override
    public RedisFuture<Long> sortReadOnly(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        return this.dispatch(this.commandBuilder.sortReadOnly(channel, key, sortArgs));
    }

    @Override
    public RedisFuture<Long> sortStore(K key, SortArgs sortArgs, K destination) {
        return this.dispatch(this.commandBuilder.sortStore(key, sortArgs, destination));
    }

    @Override
    public RedisFuture<V> spop(K key) {
        return this.dispatch(this.commandBuilder.spop(key));
    }

    @Override
    public RedisFuture<Set<V>> spop(K key, long count) {
        return this.dispatch(this.commandBuilder.spop(key, count));
    }

    @Override
    public RedisFuture<V> srandmember(K key) {
        return this.dispatch(this.commandBuilder.srandmember(key));
    }

    @Override
    public RedisFuture<List<V>> srandmember(K key, long count) {
        return this.dispatch(this.commandBuilder.srandmember(key, count));
    }

    @Override
    public RedisFuture<Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        return this.dispatch(this.commandBuilder.srandmember(channel, key, count));
    }

    @Override
    public RedisFuture<Long> srem(K key, V ... members) {
        return this.dispatch(this.commandBuilder.srem(key, members));
    }

    @Override
    public RedisFuture<ValueScanCursor<V>> sscan(K key) {
        return this.dispatch(this.commandBuilder.sscan(key));
    }

    @Override
    public RedisFuture<ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.sscan(key, scanArgs));
    }

    @Override
    public RedisFuture<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.sscan(key, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.sscan(key, scanCursor));
    }

    @Override
    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key) {
        return this.dispatch(this.commandBuilder.sscanStreaming(channel, key));
    }

    @Override
    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.sscanStreaming(channel, key, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.sscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.sscanStreaming(channel, key, scanCursor));
    }

    @Override
    public RedisFuture<Long> strlen(K key) {
        return this.dispatch(this.commandBuilder.strlen(key));
    }

    @Override
    public RedisFuture<StringMatchResult> stralgoLcs(StrAlgoArgs args2) {
        return this.dispatch(this.commandBuilder.stralgoLcs(args2));
    }

    @Override
    public RedisFuture<Set<V>> sunion(K ... keys2) {
        return this.dispatch(this.commandBuilder.sunion(keys2));
    }

    @Override
    public RedisFuture<Long> sunion(ValueStreamingChannel<V> channel, K ... keys2) {
        return this.dispatch(this.commandBuilder.sunion(channel, keys2));
    }

    @Override
    public RedisFuture<Long> sunionstore(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.sunionstore(destination, keys2));
    }

    public RedisFuture<String> swapdb(int db1, int db2) {
        return this.dispatch(this.commandBuilder.swapdb(db1, db2));
    }

    @Override
    public RedisFuture<List<V>> time() {
        return this.dispatch(this.commandBuilder.time());
    }

    @Override
    public RedisFuture<Long> touch(K ... keys2) {
        return this.dispatch(this.commandBuilder.touch(keys2));
    }

    public RedisFuture<Long> touch(Iterable<K> keys2) {
        return this.dispatch(this.commandBuilder.touch(keys2));
    }

    @Override
    public RedisFuture<Long> ttl(K key) {
        return this.dispatch(this.commandBuilder.ttl(key));
    }

    @Override
    public RedisFuture<String> type(K key) {
        return this.dispatch(this.commandBuilder.type(key));
    }

    @Override
    public RedisFuture<Long> unlink(K ... keys2) {
        return this.dispatch(this.commandBuilder.unlink(keys2));
    }

    public RedisFuture<Long> unlink(Iterable<K> keys2) {
        return this.dispatch(this.commandBuilder.unlink(keys2));
    }

    @Override
    public RedisFuture<Boolean> copy(K source2, K destination) {
        return this.dispatch(this.commandBuilder.copy(source2, destination));
    }

    @Override
    public RedisFuture<Boolean> copy(K source2, K destination, CopyArgs copyArgs) {
        return this.dispatch(this.commandBuilder.copy(source2, destination, copyArgs));
    }

    @Override
    public RedisFuture<String> unwatch() {
        return this.dispatch(this.commandBuilder.unwatch());
    }

    @Override
    public RedisFuture<Long> waitForReplication(int replicas, long timeout2) {
        return this.dispatch(this.commandBuilder.wait(replicas, timeout2));
    }

    @Override
    public RedisFuture<String> watch(K ... keys2) {
        return this.dispatch(this.commandBuilder.watch(keys2));
    }

    @Override
    public RedisFuture<Long> xack(K key, K group, String ... messageIds) {
        return this.dispatch(this.commandBuilder.xack(key, group, messageIds));
    }

    @Override
    public RedisFuture<String> xadd(K key, Map<K, V> body) {
        return this.dispatch(this.commandBuilder.xadd(key, null, body));
    }

    @Override
    public RedisFuture<String> xadd(K key, XAddArgs args2, Map<K, V> body) {
        return this.dispatch(this.commandBuilder.xadd(key, args2, body));
    }

    @Override
    public RedisFuture<String> xadd(K key, Object ... keysAndValues) {
        return this.dispatch(this.commandBuilder.xadd(key, null, keysAndValues));
    }

    @Override
    public RedisFuture<String> xadd(K key, XAddArgs args2, Object ... keysAndValues) {
        return this.dispatch(this.commandBuilder.xadd(key, args2, keysAndValues));
    }

    @Override
    public RedisFuture<ClaimedMessages<K, V>> xautoclaim(K key, XAutoClaimArgs<K> args2) {
        return this.dispatch(this.commandBuilder.xautoclaim(key, args2));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xclaim(K key, Consumer<K> consumer, long minIdleTime, String ... messageIds) {
        return this.dispatch(this.commandBuilder.xclaim(key, consumer, XClaimArgs.Builder.minIdleTime(minIdleTime), messageIds));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xclaim(K key, Consumer<K> consumer, XClaimArgs args2, String ... messageIds) {
        return this.dispatch(this.commandBuilder.xclaim(key, consumer, args2, messageIds));
    }

    @Override
    public RedisFuture<Long> xdel(K key, String ... messageIds) {
        return this.dispatch(this.commandBuilder.xdel(key, messageIds));
    }

    @Override
    public RedisFuture<String> xgroupCreate(XReadArgs.StreamOffset<K> offset, K group) {
        return this.dispatch(this.commandBuilder.xgroupCreate(offset, group, null));
    }

    @Override
    public RedisFuture<String> xgroupCreate(XReadArgs.StreamOffset<K> offset, K group, XGroupCreateArgs args2) {
        return this.dispatch(this.commandBuilder.xgroupCreate(offset, group, args2));
    }

    @Override
    public RedisFuture<Boolean> xgroupCreateconsumer(K key, Consumer<K> consumer) {
        return this.dispatch(this.commandBuilder.xgroupCreateconsumer(key, consumer));
    }

    @Override
    public RedisFuture<Long> xgroupDelconsumer(K key, Consumer<K> consumer) {
        return this.dispatch(this.commandBuilder.xgroupDelconsumer(key, consumer));
    }

    @Override
    public RedisFuture<Boolean> xgroupDestroy(K key, K group) {
        return this.dispatch(this.commandBuilder.xgroupDestroy(key, group));
    }

    @Override
    public RedisFuture<String> xgroupSetid(XReadArgs.StreamOffset<K> offset, K group) {
        return this.dispatch(this.commandBuilder.xgroupSetid(offset, group));
    }

    @Override
    public RedisFuture<List<Object>> xinfoStream(K key) {
        return this.dispatch(this.commandBuilder.xinfoStream(key));
    }

    @Override
    public RedisFuture<List<Object>> xinfoGroups(K key) {
        return this.dispatch(this.commandBuilder.xinfoGroups(key));
    }

    @Override
    public RedisFuture<List<Object>> xinfoConsumers(K key, K group) {
        return this.dispatch(this.commandBuilder.xinfoConsumers(key, group));
    }

    @Override
    public RedisFuture<Long> xlen(K key) {
        return this.dispatch(this.commandBuilder.xlen(key));
    }

    @Override
    public RedisFuture<PendingMessages> xpending(K key, K group) {
        return this.dispatch(this.commandBuilder.xpending(key, group));
    }

    @Override
    public RedisFuture<List<PendingMessage>> xpending(K key, K group, Range<String> range, Limit limit) {
        return this.dispatch(this.commandBuilder.xpending(key, group, range, limit));
    }

    @Override
    public RedisFuture<List<PendingMessage>> xpending(K key, Consumer<K> consumer, Range<String> range, Limit limit) {
        return this.dispatch(this.commandBuilder.xpending(key, consumer, range, limit));
    }

    @Override
    public RedisFuture<List<PendingMessage>> xpending(K key, XPendingArgs<K> args2) {
        return this.dispatch(this.commandBuilder.xpending(key, args2));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xrange(K key, Range<String> range) {
        return this.dispatch(this.commandBuilder.xrange(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xrange(K key, Range<String> range, Limit limit) {
        return this.dispatch(this.commandBuilder.xrange(key, range, limit));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xread(XReadArgs.StreamOffset<K> ... streams) {
        return this.dispatch(this.commandBuilder.xread(null, streams));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xread(XReadArgs args2, XReadArgs.StreamOffset<K> ... streams) {
        return this.dispatch(this.commandBuilder.xread(args2, streams));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xreadgroup(Consumer<K> consumer, XReadArgs.StreamOffset<K> ... streams) {
        return this.dispatch(this.commandBuilder.xreadgroup(consumer, null, streams));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xreadgroup(Consumer<K> consumer, XReadArgs args2, XReadArgs.StreamOffset<K> ... streams) {
        return this.dispatch(this.commandBuilder.xreadgroup(consumer, args2, streams));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xrevrange(K key, Range<String> range) {
        return this.dispatch(this.commandBuilder.xrevrange(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<StreamMessage<K, V>>> xrevrange(K key, Range<String> range, Limit limit) {
        return this.dispatch(this.commandBuilder.xrevrange(key, range, limit));
    }

    @Override
    public RedisFuture<Long> xtrim(K key, long count) {
        return this.xtrim(key, false, count);
    }

    @Override
    public RedisFuture<Long> xtrim(K key, boolean approximateTrimming, long count) {
        return this.dispatch(this.commandBuilder.xtrim(key, approximateTrimming, count));
    }

    @Override
    public RedisFuture<Long> xtrim(K key, XTrimArgs args2) {
        return this.dispatch(this.commandBuilder.xtrim(key, args2));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzmpop(long timeout2, ZPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzmpop(timeout2, args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, List<ScoredValue<V>>>> bzmpop(long timeout2, long count, ZPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzmpop(timeout2, count, args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzmpop(double timeout2, ZPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzmpop(timeout2, args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, List<ScoredValue<V>>>> bzmpop(double timeout2, int count, ZPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzmpop(timeout2, (long)count, args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzpopmin(long timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzpopmin(timeout2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzpopmin(double timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzpopmin(timeout2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzpopmax(long timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzpopmax(timeout2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> bzpopmax(double timeout2, K ... keys2) {
        return this.dispatch(this.commandBuilder.bzpopmax(timeout2, keys2));
    }

    @Override
    public RedisFuture<Long> zadd(K key, double score, V member) {
        return this.dispatch(this.commandBuilder.zadd(key, (ZAddArgs)null, score, member));
    }

    @Override
    public RedisFuture<Long> zadd(K key, Object ... scoresAndValues) {
        return this.dispatch(this.commandBuilder.zadd(key, null, scoresAndValues));
    }

    @Override
    public RedisFuture<Long> zadd(K key, ScoredValue<V> ... scoredValues) {
        return this.dispatch(this.commandBuilder.zadd(key, null, scoredValues));
    }

    @Override
    public RedisFuture<Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.dispatch(this.commandBuilder.zadd(key, zAddArgs, score, member));
    }

    @Override
    public RedisFuture<Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        return this.dispatch(this.commandBuilder.zadd(key, zAddArgs, scoresAndValues));
    }

    @Override
    public RedisFuture<Long> zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... scoredValues) {
        return this.dispatch(this.commandBuilder.zadd(key, zAddArgs, scoredValues));
    }

    @Override
    public RedisFuture<Double> zaddincr(K key, double score, V member) {
        return this.dispatch(this.commandBuilder.zaddincr(key, null, score, member));
    }

    @Override
    public RedisFuture<Double> zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.dispatch(this.commandBuilder.zaddincr(key, zAddArgs, score, member));
    }

    @Override
    public RedisFuture<Long> zcard(K key) {
        return this.dispatch(this.commandBuilder.zcard(key));
    }

    @Override
    public RedisFuture<Long> zcount(K key, double min, double max) {
        return this.dispatch(this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public RedisFuture<Long> zcount(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public RedisFuture<Long> zcount(K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zcount(key, range));
    }

    @Override
    public RedisFuture<List<V>> zdiff(K ... keys2) {
        return this.dispatch(this.commandBuilder.zdiff(keys2));
    }

    @Override
    public RedisFuture<Long> zdiffstore(K destKey, K ... srcKeys) {
        return this.dispatch(this.commandBuilder.zdiffstore(destKey, srcKeys));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zdiffWithScores(K ... keys2) {
        return this.dispatch(this.commandBuilder.zdiffWithScores(keys2));
    }

    @Override
    public RedisFuture<Double> zincrby(K key, double amount, V member) {
        return this.dispatch(this.commandBuilder.zincrby(key, amount, member));
    }

    @Override
    public RedisFuture<List<V>> zinter(K ... keys2) {
        return this.dispatch(this.commandBuilder.zinter(keys2));
    }

    @Override
    public RedisFuture<List<V>> zinter(ZAggregateArgs aggregateArgs, K ... keys2) {
        return this.dispatch(this.commandBuilder.zinter(aggregateArgs, keys2));
    }

    @Override
    public RedisFuture<Long> zintercard(K ... keys2) {
        return this.dispatch(this.commandBuilder.zintercard(keys2));
    }

    @Override
    public RedisFuture<Long> zintercard(long limit, K ... keys2) {
        return this.dispatch(this.commandBuilder.zintercard(limit, keys2));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zinterWithScores(K ... keys2) {
        return this.dispatch(this.commandBuilder.zinterWithScores(keys2));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zinterWithScores(ZAggregateArgs aggregateArgs, K ... keys2) {
        return this.dispatch(this.commandBuilder.zinterWithScores(aggregateArgs, keys2));
    }

    @Override
    public RedisFuture<Long> zinterstore(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.zinterstore(destination, keys2));
    }

    @Override
    public RedisFuture<Long> zinterstore(K destination, ZStoreArgs zStoreArgs, K ... keys2) {
        return this.dispatch(this.commandBuilder.zinterstore(destination, zStoreArgs, keys2));
    }

    @Override
    public RedisFuture<Long> zlexcount(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zlexcount(key, min, max));
    }

    @Override
    public RedisFuture<Long> zlexcount(K key, Range<? extends V> range) {
        return this.dispatch(this.commandBuilder.zlexcount(key, range));
    }

    @Override
    public RedisFuture<List<Double>> zmscore(K key, V ... members) {
        return this.dispatch(this.commandBuilder.zmscore(key, members));
    }

    @Override
    public RedisFuture<KeyValue<K, ScoredValue<V>>> zmpop(ZPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.zmpop(args2, keys2));
    }

    @Override
    public RedisFuture<KeyValue<K, List<ScoredValue<V>>>> zmpop(int count, ZPopArgs args2, K ... keys2) {
        return this.dispatch(this.commandBuilder.zmpop(count, args2, keys2));
    }

    @Override
    public RedisFuture<ScoredValue<V>> zpopmin(K key) {
        return this.dispatch(this.commandBuilder.zpopmin(key));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zpopmin(K key, long count) {
        return this.dispatch(this.commandBuilder.zpopmin(key, count));
    }

    @Override
    public RedisFuture<ScoredValue<V>> zpopmax(K key) {
        return this.dispatch(this.commandBuilder.zpopmax(key));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zpopmax(K key, long count) {
        return this.dispatch(this.commandBuilder.zpopmax(key, count));
    }

    @Override
    public RedisFuture<V> zrandmember(K key) {
        return this.dispatch(this.commandBuilder.zrandmember(key));
    }

    @Override
    public RedisFuture<List<V>> zrandmember(K key, long count) {
        return this.dispatch(this.commandBuilder.zrandmember(key, count));
    }

    @Override
    public RedisFuture<ScoredValue<V>> zrandmemberWithScores(K key) {
        return this.dispatch(this.commandBuilder.zrandmemberWithScores(key));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrandmemberWithScores(K key, long count) {
        return this.dispatch(this.commandBuilder.zrandmemberWithScores(key, count));
    }

    @Override
    public RedisFuture<List<V>> zrange(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrange(key, start, stop));
    }

    @Override
    public RedisFuture<Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrange(channel, key, start, stop));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangeWithScores(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrangeWithScores(key, start, stop));
    }

    @Override
    public RedisFuture<Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrangeWithScores(channel, key, start, stop));
    }

    @Override
    public RedisFuture<List<V>> zrangebylex(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zrangebylex(key, min, max));
    }

    @Override
    public RedisFuture<List<V>> zrangebylex(K key, Range<? extends V> range) {
        return this.dispatch(this.commandBuilder.zrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<V>> zrangebylex(K key, String min, String max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebylex(key, min, max, offset, count));
    }

    @Override
    public RedisFuture<List<V>> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangebylex(key, range, limit));
    }

    @Override
    public RedisFuture<List<V>> zrangebyscore(K key, double min, double max) {
        return this.dispatch(this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public RedisFuture<List<V>> zrangebyscore(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public RedisFuture<List<V>> zrangebyscore(K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<V>> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public RedisFuture<List<V>> zrangebyscore(K key, String min, String max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public RedisFuture<List<V>> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangebyscore(key, range, limit));
    }

    @Override
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.dispatch(this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public RedisFuture<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangebyscore(channel, key, range, limit));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public RedisFuture<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public RedisFuture<Long> zrangestore(K dstKey, K srcKey, Range<Long> range) {
        return this.dispatch(this.commandBuilder.zrangestore(dstKey, srcKey, range, false));
    }

    @Override
    public RedisFuture<Long> zrangestorebylex(K dstKey, K srcKey, Range<? extends V> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangestorebylex(dstKey, srcKey, range, limit, false));
    }

    @Override
    public RedisFuture<Long> zrangestorebyscore(K dstKey, K srcKey, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangestorebyscore(dstKey, srcKey, range, limit, false));
    }

    @Override
    public RedisFuture<Long> zrank(K key, V member) {
        return this.dispatch(this.commandBuilder.zrank(key, member));
    }

    @Override
    public RedisFuture<ScoredValue<Long>> zrankWithScore(K key, V member) {
        return this.dispatch(this.commandBuilder.zrankWithScore(key, member));
    }

    @Override
    public RedisFuture<Long> zrem(K key, V ... members) {
        return this.dispatch(this.commandBuilder.zrem(key, members));
    }

    @Override
    public RedisFuture<Long> zremrangebylex(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zremrangebylex(key, min, max));
    }

    @Override
    public RedisFuture<Long> zremrangebylex(K key, Range<? extends V> range) {
        return this.dispatch(this.commandBuilder.zremrangebylex(key, range));
    }

    @Override
    public RedisFuture<Long> zremrangebyrank(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zremrangebyrank(key, start, stop));
    }

    @Override
    public RedisFuture<Long> zremrangebyscore(K key, double min, double max) {
        return this.dispatch(this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public RedisFuture<Long> zremrangebyscore(K key, String min, String max) {
        return this.dispatch(this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public RedisFuture<Long> zremrangebyscore(K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zremrangebyscore(key, range));
    }

    @Override
    public RedisFuture<List<V>> zrevrange(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrevrange(key, start, stop));
    }

    @Override
    public RedisFuture<Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrevrange(channel, key, start, stop));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangeWithScores(K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrevrangeWithScores(key, start, stop));
    }

    @Override
    public RedisFuture<Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.dispatch(this.commandBuilder.zrevrangeWithScores(channel, key, start, stop));
    }

    @Override
    public RedisFuture<Long> zrevrangestore(K dstKey, K srcKey, Range<Long> range) {
        return this.dispatch(this.commandBuilder.zrangestore(dstKey, srcKey, range, true));
    }

    @Override
    public RedisFuture<Long> zrevrangestorebylex(K dstKey, K srcKey, Range<? extends V> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangestorebylex(dstKey, srcKey, range, limit, true));
    }

    @Override
    public RedisFuture<Long> zrevrangestorebyscore(K dstKey, K srcKey, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrangestorebyscore(dstKey, srcKey, range, limit, true));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebylex(K key, Range<? extends V> range) {
        return this.dispatch(this.commandBuilder.zrevrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrevrangebylex(key, range, limit));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebyscore(K key, double max, double min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebyscore(K key, String max, String min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebyscore(K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public RedisFuture<List<V>> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(key, range, limit));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrevrangebyscore(channel, key, range, limit));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public RedisFuture<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.dispatch(this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public RedisFuture<Long> zrevrank(K key, V member) {
        return this.dispatch(this.commandBuilder.zrevrank(key, member));
    }

    @Override
    public RedisFuture<ScoredValue<Long>> zrevrankWithScore(K key, V member) {
        return this.dispatch(this.commandBuilder.zrevrankWithScore(key, member));
    }

    @Override
    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key) {
        return this.dispatch(this.commandBuilder.zscan(key));
    }

    @Override
    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.zscan(key, scanArgs));
    }

    @Override
    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.zscan(key, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.zscan(key, scanCursor));
    }

    @Override
    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key) {
        return this.dispatch(this.commandBuilder.zscanStreaming(channel, key));
    }

    @Override
    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.zscanStreaming(channel, key, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.dispatch(this.commandBuilder.zscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public RedisFuture<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.dispatch(this.commandBuilder.zscanStreaming(channel, key, scanCursor));
    }

    @Override
    public RedisFuture<Double> zscore(K key, V member) {
        return this.dispatch(this.commandBuilder.zscore(key, member));
    }

    @Override
    public RedisFuture<List<V>> zunion(K ... keys2) {
        return this.dispatch(this.commandBuilder.zunion(keys2));
    }

    @Override
    public RedisFuture<List<V>> zunion(ZAggregateArgs aggregateArgs, K ... keys2) {
        return this.dispatch(this.commandBuilder.zunion(aggregateArgs, keys2));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zunionWithScores(K ... keys2) {
        return this.dispatch(this.commandBuilder.zunionWithScores(keys2));
    }

    @Override
    public RedisFuture<List<ScoredValue<V>>> zunionWithScores(ZAggregateArgs aggregateArgs, K ... keys2) {
        return this.dispatch(this.commandBuilder.zunionWithScores(aggregateArgs, keys2));
    }

    @Override
    public RedisFuture<Long> zunionstore(K destination, K ... keys2) {
        return this.dispatch(this.commandBuilder.zunionstore(destination, keys2));
    }

    @Override
    public RedisFuture<Long> zunionstore(K destination, ZStoreArgs zStoreArgs, K ... keys2) {
        return this.dispatch(this.commandBuilder.zunionstore(destination, zStoreArgs, keys2));
    }

    private byte[] encodeFunction(String functionCode) {
        LettuceAssert.notNull((Object)functionCode, "Function code must not be null");
        LettuceAssert.notEmpty((CharSequence)functionCode, "Function code script must not be empty");
        return functionCode.getBytes(this.getConnection().getOptions().getScriptCharset());
    }

    private byte[] encodeScript(String script) {
        LettuceAssert.notNull((Object)script, "Lua script must not be null");
        LettuceAssert.notEmpty((CharSequence)script, "Lua script must not be empty");
        return script.getBytes(this.getConnection().getOptions().getScriptCharset());
    }
}

