/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.AbstractInvocationHandler;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.TimeoutProvider;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

class FutureSyncInvocationHandler
extends AbstractInvocationHandler {
    private final StatefulConnection<?, ?> connection;
    private final TimeoutProvider timeoutProvider;
    private final Object asyncApi;
    private final AbstractInvocationHandler.MethodTranslator translator;

    FutureSyncInvocationHandler(StatefulConnection<?, ?> connection, Object asyncApi, Class<?>[] interfaces) {
        this.connection = connection;
        this.timeoutProvider = new TimeoutProvider(() -> connection.getOptions().getTimeoutOptions(), () -> connection.getTimeout().toNanos());
        this.asyncApi = asyncApi;
        this.translator = AbstractInvocationHandler.MethodTranslator.of(asyncApi.getClass(), interfaces);
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args2) throws Throwable {
        try {
            Method targetMethod = this.translator.get(method);
            Object result = targetMethod.invoke(this.asyncApi, args2);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (!FutureSyncInvocationHandler.isTxControlMethod(method.getName(), args2) && FutureSyncInvocationHandler.isTransactionActive(this.connection)) {
                    return null;
                }
                long timeout2 = this.getTimeoutNs(command);
                return Futures.awaitOrCancel(command, timeout2, TimeUnit.NANOSECONDS);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private long getTimeoutNs(RedisFuture<?> command) {
        if (command instanceof RedisCommand) {
            return this.timeoutProvider.getTimeoutNs((RedisCommand)((Object)command));
        }
        return this.connection.getTimeout().toNanos();
    }

    private static boolean isTransactionActive(StatefulConnection<?, ?> connection) {
        return connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)connection).isMulti();
    }

    private static boolean isTxControlMethod(String methodName, Object[] args2) {
        ProtocolKeyword keyword;
        if (methodName.equals("exec") || methodName.equals("multi") || methodName.equals("discard")) {
            return true;
        }
        return methodName.equals("dispatch") && args2.length > 0 && args2[0] instanceof ProtocolKeyword && ((keyword = (ProtocolKeyword)args2[0]).name().equals(CommandType.MULTI.name()) || keyword.name().equals(CommandType.EXEC.name()) || keyword.name().equals(CommandType.DISCARD.name()));
    }
}

