/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.ProtocolKeyword;

public class LMPopArgs
implements CompositeArgument {
    private final ProtocolKeyword direction;
    private Long count;

    private LMPopArgs(ProtocolKeyword source2, Long count) {
        this.direction = source2;
        this.count = count;
    }

    public LMPopArgs count(long count) {
        LettuceAssert.isTrue(count > 0L, "Count must be greater 0");
        this.count = count;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        args2.add(this.direction);
        if (this.count != null) {
            args2.add(CommandKeyword.COUNT).add(this.count);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static LMPopArgs left() {
            return new LMPopArgs(CommandKeyword.LEFT, null);
        }

        public static LMPopArgs right() {
            return new LMPopArgs(CommandKeyword.RIGHT, null);
        }
    }
}

