/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionMetadata;
import io.lettuce.core.ConnectionState;
import io.lettuce.core.RedisCommandBuilder;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisException;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.ConnectionInitializer;
import io.lettuce.core.protocol.ProtocolVersion;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class RedisHandshake
implements ConnectionInitializer {
    private static final RedisVersion CLIENT_SET_INFO_SINCE = RedisVersion.of("7.2");
    private final RedisCommandBuilder<String, String> commandBuilder = new RedisCommandBuilder<String, String>(StringCodec.UTF8);
    private final ProtocolVersion requestedProtocolVersion;
    private final boolean pingOnConnect;
    private final ConnectionState connectionState;
    private volatile ProtocolVersion negotiatedProtocolVersion;

    RedisHandshake(ProtocolVersion requestedProtocolVersion, boolean pingOnConnect, ConnectionState connectionState) {
        this.requestedProtocolVersion = requestedProtocolVersion;
        this.pingOnConnect = pingOnConnect;
        this.connectionState = connectionState;
    }

    public ProtocolVersion getRequestedProtocolVersion() {
        return this.requestedProtocolVersion;
    }

    public ProtocolVersion getNegotiatedProtocolVersion() {
        return this.negotiatedProtocolVersion;
    }

    @Override
    public CompletionStage<Void> initialize(Channel channel) {
        CompletionStage<Object> handshake2;
        if (this.requestedProtocolVersion == ProtocolVersion.RESP2) {
            handshake2 = this.initializeResp2(channel);
            this.negotiatedProtocolVersion = ProtocolVersion.RESP2;
        } else {
            handshake2 = this.requestedProtocolVersion == ProtocolVersion.RESP3 ? this.initializeResp3(channel) : (this.requestedProtocolVersion == null ? this.tryHandshakeResp3(channel) : Futures.failed(new RedisConnectionException("Protocol version" + (Object)((Object)this.requestedProtocolVersion) + " not supported")));
        }
        return handshake2.thenCompose(ignore -> this.applyPostHandshake(channel, this.connectionState.getRedisVersion(), this.getNegotiatedProtocolVersion()));
    }

    private CompletionStage<?> tryHandshakeResp3(Channel channel) {
        CompletableFuture handshake2 = new CompletableFuture();
        CompletionStage<Map<String, Object>> hello = this.initiateHandshakeResp3(channel, this.connectionState.getCredentialsProvider());
        hello.whenComplete((settings, throwable) -> {
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable != null) {
                if (RedisHandshake.isUnknownCommand(throwable) || RedisHandshake.isNoProto(throwable)) {
                    try {
                        this.fallbackToResp2(channel, handshake2);
                    }
                    catch (Exception e) {
                        e.addSuppressed((Throwable)throwable);
                        handshake2.completeExceptionally(e);
                    }
                } else {
                    handshake2.completeExceptionally((Throwable)throwable);
                }
            } else {
                this.onHelloResponse((Map<String, Object>)settings);
                handshake2.complete(null);
            }
        });
        return handshake2;
    }

    private void fallbackToResp2(Channel channel, CompletableFuture<?> handshake2) {
        this.initializeResp2(channel).whenComplete((o, nested) -> {
            if (nested != null) {
                handshake2.completeExceptionally((Throwable)nested);
            } else {
                handshake2.complete(null);
            }
        });
    }

    private CompletableFuture<?> initializeResp2(Channel channel) {
        return this.initiateHandshakeResp2(channel, this.connectionState.getCredentialsProvider()).thenRun(() -> {
            this.negotiatedProtocolVersion = ProtocolVersion.RESP2;
            this.connectionState.setHandshakeResponse(new ConnectionState.HandshakeResponse(this.negotiatedProtocolVersion, null, null, null, null));
        });
    }

    private CompletionStage<Void> initializeResp3(Channel channel) {
        return this.initiateHandshakeResp3(channel, this.connectionState.getCredentialsProvider()).thenAccept(this::onHelloResponse);
    }

    private void onHelloResponse(Map<String, Object> response) {
        Long id = (Long)response.get("id");
        String mode = (String)response.get("mode");
        String version = (String)response.get("version");
        String role = (String)response.get("role");
        this.negotiatedProtocolVersion = ProtocolVersion.RESP3;
        this.connectionState.setHandshakeResponse(new ConnectionState.HandshakeResponse(this.negotiatedProtocolVersion, id, version, mode, role));
    }

    private CompletableFuture<?> initiateHandshakeResp2(Channel channel, RedisCredentialsProvider credentialsProvider) {
        if (credentialsProvider instanceof RedisCredentialsProvider.ImmediateRedisCredentialsProvider) {
            return this.dispatchAuthOrPing(channel, ((RedisCredentialsProvider.ImmediateRedisCredentialsProvider)credentialsProvider).resolveCredentialsNow());
        }
        CompletableFuture<RedisCredentials> credentialsFuture = credentialsProvider.resolveCredentials().toFuture();
        return credentialsFuture.thenComposeAsync(credentials -> this.dispatchAuthOrPing(channel, (RedisCredentials)credentials));
    }

    private CompletableFuture<String> dispatchAuthOrPing(Channel channel, RedisCredentials credentials) {
        if (credentials.hasUsername()) {
            return this.dispatch(channel, this.commandBuilder.auth(credentials.getUsername(), credentials.getPassword()));
        }
        if (credentials.hasPassword()) {
            return this.dispatch(channel, this.commandBuilder.auth(credentials.getPassword()));
        }
        if (this.pingOnConnect) {
            return this.dispatch(channel, this.commandBuilder.ping());
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Map<String, Object>> initiateHandshakeResp3(Channel channel, RedisCredentialsProvider credentialsProvider) {
        if (credentialsProvider instanceof RedisCredentialsProvider.ImmediateRedisCredentialsProvider) {
            return this.dispatchHello(channel, ((RedisCredentialsProvider.ImmediateRedisCredentialsProvider)credentialsProvider).resolveCredentialsNow());
        }
        CompletableFuture<RedisCredentials> credentialsFuture = credentialsProvider.resolveCredentials().toFuture();
        return credentialsFuture.thenComposeAsync(credentials -> this.dispatchHello(channel, (RedisCredentials)credentials));
    }

    private AsyncCommand<String, String, Map<String, Object>> dispatchHello(Channel channel, RedisCredentials credentials) {
        if (credentials.hasPassword()) {
            return this.dispatch(channel, this.commandBuilder.hello(3, LettuceStrings.isNotEmpty(credentials.getUsername()) ? credentials.getUsername() : "default", credentials.getPassword(), this.connectionState.getClientName()));
        }
        return this.dispatch(channel, this.commandBuilder.hello(3, null, null, this.connectionState.getClientName()));
    }

    private CompletableFuture<Void> applyPostHandshake(Channel channel, String redisVersion, ProtocolVersion negotiatedProtocolVersion) {
        RedisVersion currentVersion;
        ArrayList postHandshake = new ArrayList();
        ConnectionMetadata metadata = this.connectionState.getConnectionMetadata();
        if (metadata.getClientName() != null && negotiatedProtocolVersion == ProtocolVersion.RESP2) {
            postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.clientSetname(this.connectionState.getClientName())));
        }
        if (negotiatedProtocolVersion == ProtocolVersion.RESP3 && (currentVersion = RedisVersion.of(redisVersion)).isGreaterThanOrEqualTo(CLIENT_SET_INFO_SINCE)) {
            if (LettuceStrings.isNotEmpty(metadata.getLibraryName())) {
                postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.clientSetinfo("lib-name", metadata.getLibraryName())));
            }
            if (LettuceStrings.isNotEmpty(metadata.getLibraryVersion())) {
                postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.clientSetinfo("lib-ver", metadata.getLibraryVersion())));
            }
        }
        if (this.connectionState.getDb() > 0) {
            postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.select(this.connectionState.getDb())));
        }
        if (this.connectionState.isReadOnly()) {
            postHandshake.add(new AsyncCommand<String, String, String>(this.commandBuilder.readOnly()));
        }
        if (postHandshake.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return this.dispatch(channel, postHandshake);
    }

    private CompletableFuture<Void> dispatch(Channel channel, List<AsyncCommand<?, ?, ?>> commands) {
        CompletionStage writeFuture = Futures.toCompletionStage(channel.writeAndFlush(commands));
        return CompletableFuture.allOf(Futures.allOf(commands), writeFuture.toCompletableFuture());
    }

    private <T> AsyncCommand<String, String, T> dispatch(Channel channel, Command<String, String, T> command) {
        AsyncCommand future = new AsyncCommand(command);
        channel.writeAndFlush(future).addListener(writeFuture -> {
            if (!writeFuture.isSuccess()) {
                future.completeExceptionally(writeFuture.cause());
            }
        });
        return future;
    }

    private static boolean isUnknownCommand(Throwable error) {
        return error instanceof RedisException && LettuceStrings.isNotEmpty(error.getMessage()) && error.getMessage().startsWith("ERR") && error.getMessage().contains("unknown");
    }

    private static boolean isNoProto(Throwable error) {
        return error instanceof RedisException && LettuceStrings.isNotEmpty(error.getMessage()) && error.getMessage().startsWith("NOPROTO");
    }

    static class RedisVersion {
        private static final Pattern DECIMALS = Pattern.compile("(\\d+)");
        private static final RedisVersion UNKNOWN = new RedisVersion("0.0.0");
        private static final RedisVersion UNSTABLE = new RedisVersion("255.255.255");
        private final int major;
        private final int minor;
        private final int bugfix;

        private RedisVersion(String version) {
            int major = 0;
            int minor = 0;
            int bugfix = 0;
            LettuceAssert.notNull((Object)version, "Version must not be null");
            Matcher matcher = DECIMALS.matcher(version);
            if (matcher.find()) {
                major = Integer.parseInt(matcher.group(1));
                if (matcher.find()) {
                    minor = Integer.parseInt(matcher.group(1));
                }
                if (matcher.find()) {
                    bugfix = Integer.parseInt(matcher.group(1));
                }
            }
            this.major = major;
            this.minor = minor;
            this.bugfix = bugfix;
        }

        public static RedisVersion of(String version) {
            return new RedisVersion(version);
        }

        public boolean isGreaterThan(RedisVersion version) {
            return this.compareTo(version) > 0;
        }

        public boolean isGreaterThanOrEqualTo(RedisVersion version) {
            return this.compareTo(version) >= 0;
        }

        public boolean is(RedisVersion version) {
            return this.equals(version);
        }

        public boolean isLessThan(RedisVersion version) {
            return this.compareTo(version) < 0;
        }

        public boolean isLessThanOrEqualTo(RedisVersion version) {
            return this.compareTo(version) <= 0;
        }

        public int compareTo(RedisVersion that) {
            if (this.major != that.major) {
                return this.major - that.major;
            }
            if (this.minor != that.minor) {
                return this.minor - that.minor;
            }
            return this.bugfix - that.bugfix;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RedisVersion that = (RedisVersion)o;
            return this.major == that.major && this.minor == that.minor && this.bugfix == that.bugfix;
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.bugfix);
        }

        public String toString() {
            return this.major + "." + this.minor + "." + this.bugfix;
        }
    }
}

