/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;

public class RestoreArgs
implements CompositeArgument {
    long ttl;
    private boolean replace;
    private boolean absttl;
    private Long frequency;
    private Long idleTime;

    public RestoreArgs ttl(long milliseconds) {
        this.ttl = milliseconds;
        return this;
    }

    public RestoreArgs ttl(Duration ttl) {
        LettuceAssert.notNull((Object)ttl, "Time to live must not be null");
        return this.ttl(ttl.toMillis());
    }

    public RestoreArgs replace() {
        return this.replace(true);
    }

    public RestoreArgs replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public RestoreArgs absttl() {
        return this.absttl(true);
    }

    public RestoreArgs absttl(boolean absttl) {
        this.absttl = absttl;
        return this;
    }

    public RestoreArgs idleTime(long idleTime) {
        this.idleTime = idleTime;
        return this;
    }

    public RestoreArgs frequency(long frequency) {
        this.frequency = frequency;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        if (this.replace) {
            args2.add(CommandKeyword.REPLACE);
        }
        if (this.absttl) {
            args2.add(CommandKeyword.ABSTTL);
        }
        if (this.idleTime != null) {
            args2.add(CommandKeyword.IDLETIME).add(this.idleTime);
        }
        if (this.frequency != null) {
            args2.add(CommandKeyword.FREQ).add(this.frequency);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static RestoreArgs ttl(long milliseconds) {
            return new RestoreArgs().ttl(milliseconds);
        }

        public static RestoreArgs ttl(Duration ttl) {
            LettuceAssert.notNull((Object)ttl, "Time to live must not be null");
            return Builder.ttl(ttl.toMillis());
        }
    }
}

