/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StrAlgoArgs
implements CompositeArgument {
    private boolean justLen;
    private int minMatchLen;
    private boolean withMatchLen;
    private boolean withIdx;
    private By by = By.STRINGS;
    private String[] keys;
    private Charset charset = StandardCharsets.UTF_8;

    public StrAlgoArgs minMatchLen(int minMatchLen) {
        this.minMatchLen = minMatchLen;
        return this;
    }

    public StrAlgoArgs justLen() {
        this.justLen = true;
        return this;
    }

    public StrAlgoArgs withMatchLen() {
        this.withMatchLen = true;
        return this;
    }

    public StrAlgoArgs withIdx() {
        this.withIdx = true;
        return this;
    }

    public StrAlgoArgs by(By by, String ... keys2) {
        LettuceAssert.notNull((Object)by, "By-selector must not be null");
        LettuceAssert.notEmpty((Object[])keys2, "Keys must not be empty");
        this.by = by;
        this.keys = keys2;
        return this;
    }

    public boolean isWithIdx() {
        return this.withIdx;
    }

    public StrAlgoArgs charset(Charset charset) {
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        this.charset = charset;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        args2.add("LCS");
        args2.add(this.by.name());
        for (String key : this.keys) {
            if (this.by == By.STRINGS) {
                args2.add(key.getBytes(this.charset));
                continue;
            }
            args2.add(key);
        }
        if (this.justLen) {
            args2.add("LEN");
        }
        if (this.withIdx) {
            args2.add("IDX");
        }
        if (this.minMatchLen > 0) {
            args2.add("MINMATCHLEN");
            args2.add(this.minMatchLen);
        }
        if (this.withMatchLen) {
            args2.add("WITHMATCHLEN");
        }
    }

    public static enum By {
        STRINGS,
        KEYS;

    }

    public static class Builder {
        private Builder() {
        }

        public static StrAlgoArgs keys(String ... keys2) {
            return new StrAlgoArgs().by(By.KEYS, keys2);
        }

        public static StrAlgoArgs strings(String ... strings) {
            return new StrAlgoArgs().by(By.STRINGS, strings);
        }

        public static StrAlgoArgs strings(Charset charset, String ... strings) {
            return new StrAlgoArgs().by(By.STRINGS, strings).charset(charset);
        }
    }
}

