/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;

public class XClaimArgs
implements CompositeArgument {
    long minIdleTime;
    private Long idle;
    private Long time;
    private Long retrycount;
    private boolean force;
    private boolean justid;

    public XClaimArgs justid() {
        this.justid = true;
        return this;
    }

    public XClaimArgs minIdleTime(long milliseconds) {
        this.minIdleTime = milliseconds;
        return this;
    }

    public XClaimArgs minIdleTime(Duration minIdleTime) {
        LettuceAssert.notNull((Object)minIdleTime, "Min idle time must not be null");
        return this.minIdleTime(minIdleTime.toMillis());
    }

    public XClaimArgs idle(long milliseconds) {
        this.idle = milliseconds;
        return this;
    }

    public XClaimArgs idle(Duration idleTime) {
        LettuceAssert.notNull((Object)idleTime, "Idle time must not be null");
        return this.idle(idleTime.toMillis());
    }

    public XClaimArgs time(long millisecondsUnixTime) {
        this.time = millisecondsUnixTime;
        return this;
    }

    public XClaimArgs time(TemporalAccessor timestamp) {
        LettuceAssert.notNull((Object)timestamp, "Timestamp must not be null");
        return this.time(Instant.from(timestamp).toEpochMilli());
    }

    public XClaimArgs retryCount(long retrycount) {
        this.retrycount = retrycount;
        return this;
    }

    public XClaimArgs force() {
        return this.force(true);
    }

    public XClaimArgs force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        if (this.idle != null) {
            args2.add(CommandKeyword.IDLE).add(this.idle);
        }
        if (this.time != null) {
            args2.add(CommandType.TIME).add(this.time);
        }
        if (this.retrycount != null) {
            args2.add(CommandKeyword.RETRYCOUNT).add(this.retrycount);
        }
        if (this.force) {
            args2.add(CommandKeyword.FORCE);
        }
        if (this.justid) {
            args2.add(CommandKeyword.JUSTID);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XClaimArgs justid() {
            return new XClaimArgs().justid();
        }

        public static XClaimArgs minIdleTime(long milliseconds) {
            return new XClaimArgs().minIdleTime(milliseconds);
        }

        public static XClaimArgs minIdleTime(Duration minIdleTime) {
            LettuceAssert.notNull((Object)minIdleTime, "Min idle time must not be null");
            return Builder.minIdleTime(minIdleTime.toMillis());
        }
    }
}

