/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.Consumer;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.time.Duration;

public class XPendingArgs<K>
implements CompositeArgument {
    private K group;
    private K consumer;
    private Range<String> range;
    private Limit limit;
    private Long idle;

    public XPendingArgs<K> range(Range<String> range) {
        LettuceAssert.notNull(range, "Range must not be null");
        this.range = range;
        return this;
    }

    public XPendingArgs<K> consumer(Consumer<K> consumer) {
        LettuceAssert.notNull(consumer, "Consumer must not be null");
        this.consumer = consumer.getName();
        return this.group(consumer.getGroup());
    }

    public XPendingArgs<K> group(K group) {
        LettuceAssert.notNull(group, "Group must not be null");
        this.group = group;
        return this;
    }

    public XPendingArgs<K> limit(Limit limit) {
        LettuceAssert.notNull((Object)limit, "Limit must not be null");
        this.limit = limit;
        return this;
    }

    public XPendingArgs<K> idle(Duration timeout2) {
        LettuceAssert.notNull((Object)timeout2, "Timeout must not be null");
        return this.idle(timeout2.toMillis());
    }

    public XPendingArgs<K> idle(long milliseconds) {
        this.idle = milliseconds;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args2) {
        args2.addKey(this.group);
        if (this.idle != null) {
            args2.add(CommandKeyword.IDLE).add(this.idle);
        }
        if (this.range.getLower().equals(Range.Boundary.unbounded())) {
            args2.add("-");
        } else {
            args2.add(this.range.getLower().getValue());
        }
        if (this.range.getUpper().equals(Range.Boundary.unbounded())) {
            args2.add("+");
        } else {
            args2.add(this.range.getUpper().getValue());
        }
        args2.add(this.limit.isLimited() ? this.limit.getCount() : Long.MAX_VALUE);
        if (this.consumer != null) {
            args2.addKey(this.consumer);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K> XPendingArgs<K> xpending(Consumer<K> consumer, Range<String> range, Limit limit) {
            return new XPendingArgs<K>().consumer(consumer).range(range).limit(limit);
        }

        public static <K> XPendingArgs<K> xpending(K group, Range<String> range, Limit limit) {
            return new XPendingArgs<K>().group(group).range(range).limit(limit);
        }
    }
}

