/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.AbstractNodeSelection;
import io.lettuce.core.cluster.AsyncExecutionsImpl;
import io.lettuce.core.cluster.ReactiveExecutionsImpl;
import io.lettuce.core.cluster.SyncExecutionsImpl;
import io.lettuce.core.cluster.api.NodeSelectionSupport;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.AbstractInvocationHandler;
import io.lettuce.core.internal.ExceptionFactory;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.TimeoutProvider;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.RedisCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class NodeSelectionInvocationHandler
extends AbstractInvocationHandler {
    private static final Method NULL_MARKER_METHOD;
    private final Map<Method, Method> nodeSelectionMethods = new ConcurrentHashMap<Method, Method>();
    private final Map<Method, Method> connectionMethod = new ConcurrentHashMap<Method, Method>();
    private final Class<?> commandsInterface;
    private final AbstractNodeSelection<?, ?, ?, ?> selection;
    private final ExecutionModel executionModel;
    private final TimeoutProvider timeoutProvider;

    NodeSelectionInvocationHandler(AbstractNodeSelection<?, ?, ?, ?> selection, Class<?> commandsInterface, ExecutionModel executionModel) {
        this(selection, commandsInterface, null, executionModel);
    }

    NodeSelectionInvocationHandler(AbstractNodeSelection<?, ?, ?, ?> selection, Class<?> commandsInterface, TimeoutProvider timeoutProvider) {
        this(selection, commandsInterface, timeoutProvider, ExecutionModel.SYNC);
    }

    private NodeSelectionInvocationHandler(AbstractNodeSelection<?, ?, ?, ?> selection, Class<?> commandsInterface, TimeoutProvider timeoutProvider, ExecutionModel executionModel) {
        if (executionModel == ExecutionModel.SYNC) {
            LettuceAssert.notNull((Object)timeoutProvider, "TimeoutProvider must not be null");
        }
        LettuceAssert.notNull((Object)executionModel, "ExecutionModel must not be null");
        this.selection = selection;
        this.commandsInterface = commandsInterface;
        this.timeoutProvider = timeoutProvider;
        this.executionModel = executionModel;
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args2) throws Throwable {
        try {
            if (method.getName().equals("commands") && args2.length == 0) {
                return proxy;
            }
            Method targetMethod = this.findMethod(this.commandsInterface, method, this.connectionMethod);
            if (targetMethod == null) {
                Method nodeSelectionMethod = this.findMethod(NodeSelectionSupport.class, method, this.nodeSelectionMethods);
                return nodeSelectionMethod.invoke(this.selection, args2);
            }
            LinkedHashMap connections = new LinkedHashMap(this.selection.size(), 1.0f);
            connections.putAll(this.selection.statefulMap());
            LinkedHashMap<RedisClusterNode, Object> executions = new LinkedHashMap<RedisClusterNode, Object>(this.selection.size(), 1.0f);
            AtomicLong timeout2 = new AtomicLong();
            for (Map.Entry entry : connections.entrySet()) {
                CompletableFuture connection = (CompletableFuture)entry.getValue();
                CompletionStage result = connection.thenCompose(it -> {
                    try {
                        Object resultValue = this.doInvoke(args2, targetMethod, (StatefulRedisConnection<?, ?>)it);
                        if (this.timeoutProvider != null && resultValue instanceof RedisCommand && timeout2.get() == 0L) {
                            timeout2.set(this.timeoutProvider.getTimeoutNs((RedisCommand)resultValue));
                        }
                        if (resultValue instanceof CompletionStage) {
                            return (CompletionStage)resultValue;
                        }
                        return CompletableFuture.completedFuture(resultValue);
                    }
                    catch (InvocationTargetException e) {
                        CompletableFuture future = new CompletableFuture();
                        future.completeExceptionally(e.getTargetException());
                        return future;
                    }
                    catch (Exception e) {
                        CompletableFuture future = new CompletableFuture();
                        future.completeExceptionally(e);
                        return future;
                    }
                });
                executions.put((RedisClusterNode)entry.getKey(), result);
            }
            return this.getExecutions(executions, timeout2.get());
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object doInvoke(Object[] args2, Method targetMethod, StatefulRedisConnection<?, ?> it) throws IllegalAccessException, InvocationTargetException {
        Object[] argsToUse = args2;
        if (targetMethod.getName().equals("dispatch") && args2.length > 1 && args2[1] instanceof Supplier) {
            argsToUse = new Object[args2.length];
            System.arraycopy(args2, 0, argsToUse, 0, args2.length);
            argsToUse[1] = ((Supplier)args2[1]).get();
        }
        return targetMethod.invoke(this.executionModel == ExecutionModel.REACTIVE ? it.reactive() : it.async(), argsToUse);
    }

    private Object getExecutions(Map<RedisClusterNode, Object> executions, long timeoutNs) throws ExecutionException, InterruptedException {
        if (this.executionModel == ExecutionModel.REACTIVE) {
            Map<RedisClusterNode, Object> reactiveExecutions = executions;
            return new ReactiveExecutionsImpl(reactiveExecutions);
        }
        Map<RedisClusterNode, Object> asyncExecutions = executions;
        if (this.executionModel == ExecutionModel.SYNC) {
            long timeoutToUse;
            long l = timeoutToUse = timeoutNs >= 0L ? timeoutNs : this.timeoutProvider.getTimeoutNs(null);
            if (!NodeSelectionInvocationHandler.awaitAll(timeoutToUse, TimeUnit.NANOSECONDS, asyncExecutions.values())) {
                throw this.createTimeoutException(asyncExecutions, Duration.ofNanos(timeoutToUse));
            }
            if (this.atLeastOneFailed(asyncExecutions)) {
                throw this.createExecutionException(asyncExecutions);
            }
            return new SyncExecutionsImpl(asyncExecutions);
        }
        return new AsyncExecutionsImpl(asyncExecutions);
    }

    private static boolean awaitAll(long timeout2, TimeUnit unit, Collection<CompletionStage<?>> stages) {
        CompletableFuture[] futures = new CompletableFuture[stages.size()];
        int i = 0;
        for (CompletionStage<?> completableFuture : stages) {
            futures[i++] = completableFuture.toCompletableFuture();
        }
        return Futures.awaitAll(timeout2, unit, futures);
    }

    private boolean atLeastOneFailed(Map<RedisClusterNode, CompletionStage<?>> executions) {
        return executions.values().stream().anyMatch(completionStage -> completionStage.toCompletableFuture().isCompletedExceptionally());
    }

    private RedisCommandTimeoutException createTimeoutException(Map<RedisClusterNode, CompletionStage<?>> executions, Duration timeout2) {
        ArrayList<RedisClusterNode> notFinished = new ArrayList<RedisClusterNode>();
        executions.forEach((redisClusterNode, completionStage) -> {
            if (!completionStage.toCompletableFuture().isDone()) {
                notFinished.add((RedisClusterNode)redisClusterNode);
            }
        });
        String description = this.getNodeDescription(notFinished);
        return ExceptionFactory.createTimeoutException("Command timed out for node(s): " + description, timeout2);
    }

    private RedisCommandExecutionException createExecutionException(Map<RedisClusterNode, CompletionStage<?>> executions) {
        ArrayList<RedisClusterNode> failed = new ArrayList<RedisClusterNode>();
        executions.forEach((redisClusterNode, completionStage) -> {
            if (!completionStage.toCompletableFuture().isCompletedExceptionally()) {
                failed.add((RedisClusterNode)redisClusterNode);
            }
        });
        RedisCommandExecutionException e = ExceptionFactory.createExecutionException("Multi-node command execution failed on node(s): " + this.getNodeDescription(failed));
        executions.forEach((redisClusterNode, completionStage) -> {
            CompletableFuture completableFuture = completionStage.toCompletableFuture();
            if (completableFuture.isCompletedExceptionally()) {
                try {
                    completableFuture.get();
                }
                catch (Exception innerException) {
                    if (innerException instanceof ExecutionException) {
                        e.addSuppressed(innerException.getCause());
                    }
                    e.addSuppressed(innerException);
                }
            }
        });
        return e;
    }

    private String getNodeDescription(List<RedisClusterNode> notFinished) {
        return String.join((CharSequence)", ", notFinished.stream().map(this::getDescriptor).collect(Collectors.toList()));
    }

    private String getDescriptor(RedisClusterNode redisClusterNode) {
        StringBuilder buffer = new StringBuilder(redisClusterNode.getNodeId());
        buffer.append(" (");
        if (redisClusterNode.getUri() != null) {
            buffer.append(redisClusterNode.getUri().getHost()).append(':').append(redisClusterNode.getUri().getPort());
        }
        buffer.append(')');
        return buffer.toString();
    }

    private Method findMethod(Class<?> type, Method method, Map<Method, Method> cache) {
        Method result = cache.get(method);
        if (result != null && result != NULL_MARKER_METHOD) {
            return result;
        }
        Object[] parameterTypes = method.getParameterTypes();
        if (method.getName().equals("dispatch")) {
            parameterTypes[1] = CommandOutput.class;
        }
        for (Method typeMethod : type.getMethods()) {
            if (!typeMethod.getName().equals(method.getName()) || !Arrays.equals(typeMethod.getParameterTypes(), parameterTypes)) continue;
            cache.put(method, typeMethod);
            return typeMethod;
        }
        cache.put(method, NULL_MARKER_METHOD);
        return null;
    }

    static {
        try {
            NULL_MARKER_METHOD = NodeSelectionInvocationHandler.class.getDeclaredMethod("handleInvocation", Object.class, Method.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    static enum ExecutionModel {
        SYNC,
        ASYNC,
        REACTIVE;

    }
}

