/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.codec;

import io.lettuce.core.codec.ByteBufferInputStream;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;

public abstract class CompressionCodec {
    private CompressionCodec() {
    }

    public static <K, V> RedisCodec<K, V> valueCompressor(RedisCodec<K, V> delegate, CompressionType compressionType) {
        LettuceAssert.notNull(delegate, "RedisCodec must not be null");
        LettuceAssert.notNull((Object)compressionType, "CompressionType must not be null");
        return new CompressingValueCodecWrapper(delegate, compressionType);
    }

    private static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        LettuceAssert.notNull((Object)from, "From must not be null");
        LettuceAssert.notNull((Object)to, "From must not be null");
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static enum CompressionType {
        GZIP,
        DEFLATE;

    }

    private static class CompressingValueCodecWrapper
    implements RedisCodec<Object, Object> {
        private RedisCodec<Object, Object> delegate;
        private CompressionType compressionType;

        public CompressingValueCodecWrapper(RedisCodec<Object, Object> delegate, CompressionType compressionType) {
            this.delegate = delegate;
            this.compressionType = compressionType;
        }

        @Override
        public Object decodeKey(ByteBuffer bytes) {
            return this.delegate.decodeKey(bytes);
        }

        @Override
        public Object decodeValue(ByteBuffer bytes) {
            try {
                return this.delegate.decodeValue(this.decompress(bytes));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public ByteBuffer encodeKey(Object key) {
            return this.delegate.encodeKey(key);
        }

        @Override
        public ByteBuffer encodeValue(Object value) {
            try {
                return this.compress(this.delegate.encodeValue(value));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer compress(ByteBuffer source2) throws IOException {
            if (source2.remaining() == 0) {
                return source2;
            }
            OutputStream compressor = null;
            try (ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream(source2.remaining() / 2);){
                try (ByteBufferInputStream sourceStream = new ByteBufferInputStream(source2);){
                    if (this.compressionType == CompressionType.GZIP) {
                        compressor = new GZIPOutputStream(outputStream2);
                    }
                    if (this.compressionType == CompressionType.DEFLATE) {
                        compressor = new DeflaterOutputStream(outputStream2);
                    }
                    CompressionCodec.copy(sourceStream, compressor);
                }
                finally {
                    if (compressor != null) {
                        compressor.close();
                    }
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream2.toByteArray());
                return byteBuffer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer decompress(ByteBuffer source2) throws IOException {
            if (source2.remaining() == 0) {
                return source2;
            }
            InputStream decompressor = null;
            try (ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream(source2.remaining() * 2);){
                try (ByteBufferInputStream sourceStream = new ByteBufferInputStream(source2);){
                    if (this.compressionType == CompressionType.GZIP) {
                        decompressor = new GZIPInputStream(sourceStream);
                    }
                    if (this.compressionType == CompressionType.DEFLATE) {
                        decompressor = new InflaterInputStream(sourceStream);
                    }
                    CompressionCodec.copy(decompressor, outputStream2);
                }
                finally {
                    if (decompressor != null) {
                        decompressor.close();
                    }
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream2.toByteArray());
                return byteBuffer;
            }
        }
    }
}

