/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisException;
import io.lettuce.core.api.push.PushListener;
import io.lettuce.core.internal.Futures;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceFactories;
import io.lettuce.core.protocol.ActivationCommand;
import io.lettuce.core.protocol.ChannelLogDescriptor;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.ConnectionWatchdog;
import io.lettuce.core.protocol.DemandAware;
import io.lettuce.core.protocol.Endpoint;
import io.lettuce.core.protocol.HasQueuedCommands;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.PushHandler;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.protocol.SharedLock;
import io.lettuce.core.resource.ClientResources;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.EncoderException;
import io.netty.util.Recycler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DefaultEndpoint
implements RedisChannelWriter,
Endpoint,
PushHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultEndpoint.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong();
    private static final AtomicIntegerFieldUpdater<DefaultEndpoint> QUEUE_SIZE = AtomicIntegerFieldUpdater.newUpdater(DefaultEndpoint.class, "queueSize");
    private static final AtomicIntegerFieldUpdater<DefaultEndpoint> STATUS = AtomicIntegerFieldUpdater.newUpdater(DefaultEndpoint.class, "status");
    private static final int ST_OPEN = 0;
    private static final int ST_CLOSED = 1;
    protected volatile Channel channel;
    private final Reliability reliability;
    private final ClientOptions clientOptions;
    private final ClientResources clientResources;
    private final Queue<RedisCommand<?, ?, ?>> disconnectedBuffer;
    private final Queue<RedisCommand<?, ?, ?>> commandBuffer;
    private final boolean boundedQueues;
    private final boolean rejectCommandsWhileDisconnected;
    private final long endpointId = ENDPOINT_COUNTER.incrementAndGet();
    private final List<PushListener> pushListeners = new CopyOnWriteArrayList<PushListener>();
    private final SharedLock sharedLock = new SharedLock();
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private String logPrefix;
    private boolean autoFlushCommands = true;
    private boolean inActivation = false;
    private ConnectionWatchdog connectionWatchdog;
    private ConnectionFacade connectionFacade;
    private volatile Throwable connectionError;
    private volatile int queueSize = 0;
    private volatile int status = 0;
    private final String cachedEndpointId;

    public DefaultEndpoint(ClientOptions clientOptions, ClientResources clientResources) {
        LettuceAssert.notNull((Object)clientOptions, "ClientOptions must not be null");
        LettuceAssert.notNull((Object)clientOptions, "ClientResources must not be null");
        this.clientOptions = clientOptions;
        this.clientResources = clientResources;
        this.reliability = clientOptions.isAutoReconnect() ? Reliability.AT_LEAST_ONCE : Reliability.AT_MOST_ONCE;
        this.disconnectedBuffer = LettuceFactories.newConcurrentQueue(clientOptions.getRequestQueueSize());
        this.commandBuffer = LettuceFactories.newConcurrentQueue(clientOptions.getRequestQueueSize());
        this.boundedQueues = clientOptions.getRequestQueueSize() != Integer.MAX_VALUE;
        this.rejectCommandsWhileDisconnected = DefaultEndpoint.isRejectCommand(clientOptions);
        this.cachedEndpointId = "0x" + Long.toHexString(this.endpointId);
    }

    @Override
    public void setConnectionFacade(ConnectionFacade connectionFacade) {
        this.connectionFacade = connectionFacade;
    }

    @Override
    public ClientResources getClientResources() {
        return this.clientResources;
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.autoFlushCommands = autoFlush;
    }

    @Override
    public void addListener(PushListener listener) {
        this.pushListeners.add(listener);
    }

    @Override
    public void removeListener(PushListener listener) {
        this.pushListeners.remove(listener);
    }

    public List<PushListener> getPushListeners() {
        return this.pushListeners;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        LettuceAssert.notNull(command, "Command must not be null");
        RedisException validation = this.validateWrite(1);
        if (validation != null) {
            command.completeExceptionally(validation);
            return command;
        }
        try {
            this.sharedLock.incrementWriters();
            if (this.inActivation) {
                command = this.processActivationCommand(command);
            }
            if (this.autoFlushCommands) {
                if (this.isConnected()) {
                    this.writeToChannelAndFlush(command);
                } else {
                    this.writeToDisconnectedBuffer(command);
                }
            } else {
                this.writeToBuffer(command);
            }
        }
        finally {
            this.sharedLock.decrementWriters();
            if (this.debugEnabled) {
                logger.debug("{} write() done", (Object)this.logPrefix());
            }
        }
        return command;
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        RedisException validation = this.validateWrite(commands.size());
        if (validation != null) {
            commands.forEach(it -> it.completeExceptionally(validation));
            return commands;
        }
        try {
            this.sharedLock.incrementWriters();
            if (this.inActivation) {
                commands = this.processActivationCommands(commands);
            }
            if (this.autoFlushCommands) {
                if (this.isConnected()) {
                    this.writeToChannelAndFlush(commands);
                } else {
                    this.writeToDisconnectedBuffer(commands);
                }
            } else {
                this.writeToBuffer((RedisCommand)((Object)commands));
            }
        }
        finally {
            this.sharedLock.decrementWriters();
            if (this.debugEnabled) {
                logger.debug("{} write() done", (Object)this.logPrefix());
            }
        }
        return commands;
    }

    private <K, V, T> RedisCommand<K, V, T> processActivationCommand(RedisCommand<K, V, T> command) {
        if (!ActivationCommand.isActivationCommand(command)) {
            return new ActivationCommand<K, V, T>(command);
        }
        return command;
    }

    private <K, V> Collection<RedisCommand<K, V, ?>> processActivationCommands(Collection<? extends RedisCommand<K, V, ?>> commands) {
        ArrayList commandsToReturn = new ArrayList(commands.size());
        for (RedisCommand<K, V, ?> command : commands) {
            if (!ActivationCommand.isActivationCommand(command)) {
                command = new ActivationCommand(command);
            }
            commandsToReturn.add(command);
        }
        return commandsToReturn;
    }

    private RedisException validateWrite(int commands) {
        if (this.isClosed()) {
            return new RedisException("Connection is closed");
        }
        if (this.usesBoundedQueues()) {
            boolean connected = this.isConnected();
            if (QUEUE_SIZE.get(this) + commands > this.clientOptions.getRequestQueueSize()) {
                return new RedisException("Request queue size exceeded: " + this.clientOptions.getRequestQueueSize() + ". Commands are not accepted until the queue size drops.");
            }
            if (!connected && this.disconnectedBuffer.size() + commands > this.clientOptions.getRequestQueueSize()) {
                return new RedisException("Request queue size exceeded: " + this.clientOptions.getRequestQueueSize() + ". Commands are not accepted until the queue size drops.");
            }
            if (connected && this.commandBuffer.size() + commands > this.clientOptions.getRequestQueueSize()) {
                return new RedisException("Command buffer size exceeded: " + this.clientOptions.getRequestQueueSize() + ". Commands are not accepted until the queue size drops.");
            }
        }
        if (!this.isConnected() && this.rejectCommandsWhileDisconnected) {
            return new RedisException("Currently not connected. Commands are rejected.");
        }
        return null;
    }

    private boolean usesBoundedQueues() {
        return this.boundedQueues;
    }

    private void writeToBuffer(Iterable<? extends RedisCommand<?, ?, ?>> commands) {
        for (RedisCommand<?, ?, ?> command : commands) {
            this.writeToBuffer(command);
        }
    }

    private void writeToDisconnectedBuffer(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        for (RedisCommand<?, ?, ?> command : commands) {
            this.writeToDisconnectedBuffer(command);
        }
    }

    private void writeToDisconnectedBuffer(RedisCommand<?, ?, ?> command) {
        if (this.connectionError != null) {
            if (this.debugEnabled) {
                logger.debug("{} writeToDisconnectedBuffer() Completing command {} due to connection error", (Object)this.logPrefix(), command);
            }
            command.completeExceptionally(this.connectionError);
            return;
        }
        if (this.debugEnabled) {
            logger.debug("{} writeToDisconnectedBuffer() buffering (disconnected) command {}", (Object)this.logPrefix(), command);
        }
        this.disconnectedBuffer.add(command);
    }

    protected <C extends RedisCommand<?, ?, T>, T> void writeToBuffer(C command) {
        if (this.debugEnabled) {
            logger.debug("{} writeToBuffer() buffering command {}", (Object)this.logPrefix(), command);
        }
        if (this.connectionError != null) {
            if (this.debugEnabled) {
                logger.debug("{} writeToBuffer() Completing command {} due to connection error", (Object)this.logPrefix(), command);
            }
            command.completeExceptionally(this.connectionError);
            return;
        }
        this.commandBuffer.add(command);
    }

    private void writeToChannelAndFlush(RedisCommand<?, ?, ?> command) {
        QUEUE_SIZE.incrementAndGet(this);
        ChannelFuture channelFuture = this.channelWriteAndFlush(command);
        if (this.reliability == Reliability.AT_MOST_ONCE) {
            channelFuture.addListener((GenericFutureListener)AtMostOnceWriteListener.newInstance(this, command));
        }
        if (this.reliability == Reliability.AT_LEAST_ONCE) {
            channelFuture.addListener((GenericFutureListener)RetryListener.newInstance(this, command));
        }
    }

    private void writeToChannelAndFlush(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        QUEUE_SIZE.addAndGet(this, commands.size());
        if (this.reliability == Reliability.AT_MOST_ONCE) {
            for (RedisCommand<?, ?, ?> command : commands) {
                this.channelWrite(command).addListener((GenericFutureListener)AtMostOnceWriteListener.newInstance(this, command));
            }
        }
        if (this.reliability == Reliability.AT_LEAST_ONCE) {
            for (RedisCommand<?, ?, ?> command : commands) {
                this.channelWrite(command).addListener((GenericFutureListener)RetryListener.newInstance(this, command));
            }
        }
        this.channelFlush();
    }

    private void channelFlush() {
        if (this.debugEnabled) {
            logger.debug("{} write() channelFlush", (Object)this.logPrefix());
        }
        this.channel.flush();
    }

    private ChannelFuture channelWrite(RedisCommand<?, ?, ?> command) {
        if (this.debugEnabled) {
            logger.debug("{} write() channelWrite command {}", (Object)this.logPrefix(), command);
        }
        return this.channel.write(command);
    }

    private ChannelFuture channelWriteAndFlush(RedisCommand<?, ?, ?> command) {
        if (this.debugEnabled) {
            logger.debug("{} write() writeAndFlush command {}", (Object)this.logPrefix(), command);
        }
        return this.channel.writeAndFlush(command);
    }

    @Override
    public void notifyChannelActive(Channel channel) {
        this.logPrefix = null;
        this.channel = channel;
        this.connectionError = null;
        if (this.isClosed()) {
            logger.info("{} Closing channel because endpoint is already closed", (Object)this.logPrefix());
            channel.close();
            return;
        }
        if (this.connectionWatchdog != null) {
            this.connectionWatchdog.arm();
        }
        this.sharedLock.doExclusive(() -> {
            try {
                if (this.debugEnabled) {
                    logger.debug("{} activateEndpointAndExecuteBufferedCommands {} command(s) buffered", (Object)this.logPrefix(), (Object)this.disconnectedBuffer.size());
                }
                if (this.debugEnabled) {
                    logger.debug("{} activating endpoint", (Object)this.logPrefix());
                }
                try {
                    this.inActivation = true;
                    this.connectionFacade.activated();
                }
                finally {
                    this.inActivation = false;
                }
                this.flushCommands(this.disconnectedBuffer);
            }
            catch (Exception e) {
                if (this.debugEnabled) {
                    logger.debug("{} channelActive() ran into an exception", (Object)this.logPrefix());
                }
                if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                    this.reset();
                }
                throw e;
            }
        });
    }

    @Override
    public void notifyChannelInactive(Channel channel) {
        if (this.isClosed()) {
            Lazy<RedisException> lazy = Lazy.of(() -> new RedisException("Connection closed"));
            this.cancelCommands("Connection closed", this.drainCommands(), it -> it.completeExceptionally((Throwable)lazy.get()));
        }
        this.sharedLock.doExclusive(() -> {
            if (this.debugEnabled) {
                logger.debug("{} deactivating endpoint handler", (Object)this.logPrefix());
            }
            this.connectionFacade.deactivated();
        });
        if (this.channel == channel) {
            this.channel = null;
        }
    }

    @Override
    public void notifyException(Throwable t) {
        if (t instanceof RedisConnectionException && RedisConnectionException.isProtectedMode(t.getMessage())) {
            this.connectionError = t;
            this.doExclusive(this::drainCommands).forEach(cmd -> cmd.completeExceptionally(t));
        }
        if (!this.isConnected()) {
            this.connectionError = t;
        }
    }

    @Override
    public void registerConnectionWatchdog(ConnectionWatchdog connectionWatchdog) {
        this.connectionWatchdog = connectionWatchdog;
    }

    @Override
    public void flushCommands() {
        this.flushCommands(this.commandBuffer);
    }

    private void flushCommands(Queue<RedisCommand<?, ?, ?>> queue) {
        if (this.debugEnabled) {
            logger.debug("{} flushCommands()", (Object)this.logPrefix());
        }
        if (this.isConnected()) {
            List commands = this.sharedLock.doExclusive(() -> {
                if (queue.isEmpty()) {
                    return Collections.emptyList();
                }
                return DefaultEndpoint.drainCommands(queue);
            });
            if (this.debugEnabled) {
                logger.debug("{} flushCommands() Flushing {} commands", (Object)this.logPrefix(), (Object)commands.size());
            }
            if (!commands.isEmpty()) {
                this.writeToChannelAndFlush(commands);
            }
        }
    }

    @Override
    public void close() {
        if (this.debugEnabled) {
            logger.debug("{} close()", (Object)this.logPrefix());
        }
        this.closeAsync().join();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (this.debugEnabled) {
            logger.debug("{} closeAsync()", (Object)this.logPrefix());
        }
        if (this.isClosed()) {
            return this.closeFuture;
        }
        if (STATUS.compareAndSet(this, 0, 1)) {
            if (this.connectionWatchdog != null) {
                this.connectionWatchdog.prepareClose();
            }
            this.cancelBufferedCommands("Close");
            Channel channel = this.getOpenChannel();
            if (channel != null) {
                Futures.adapt(channel.close(), this.closeFuture);
            } else {
                this.closeFuture.complete(null);
            }
        }
        return this.closeFuture;
    }

    public void disconnect() {
        Channel channel = this.channel;
        if (channel != null && channel.isOpen()) {
            channel.disconnect();
        }
    }

    private Channel getOpenChannel() {
        Channel currentChannel = this.channel;
        if (currentChannel != null) {
            return currentChannel;
        }
        return null;
    }

    @Override
    public void reset() {
        if (this.debugEnabled) {
            logger.debug("{} reset()", (Object)this.logPrefix());
        }
        if (this.channel != null) {
            this.channel.pipeline().fireUserEventTriggered((Object)new ConnectionEvents.Reset());
        }
        this.cancelBufferedCommands("Reset");
    }

    @Override
    public void initialState() {
        this.commandBuffer.clear();
        Channel currentChannel = this.channel;
        if (currentChannel != null) {
            ChannelFuture close = currentChannel.close();
            if (currentChannel.isOpen()) {
                close.syncUninterruptibly();
            }
        }
    }

    @Override
    public void notifyDrainQueuedCommands(HasQueuedCommands queuedCommands) {
        if (this.isClosed()) {
            Lazy<RedisException> lazy = Lazy.of(() -> new RedisException("Connection closed"));
            this.cancelCommands("Connection closed", queuedCommands.drainQueue(), it -> it.completeExceptionally((Throwable)lazy.get()));
            this.cancelCommands("Connection closed", this.drainCommands(), it -> it.completeExceptionally((Throwable)lazy.get()));
            return;
        }
        if (this.reliability == Reliability.AT_MOST_ONCE && this.rejectCommandsWhileDisconnected) {
            Lazy<RedisException> lazy = Lazy.of(() -> new RedisException("Connection disconnected"));
            this.cancelCommands("Connection disconnected", queuedCommands.drainQueue(), it -> it.completeExceptionally((Throwable)lazy.get()));
            this.cancelCommands("Connection disconnected", this.drainCommands(), it -> it.completeExceptionally((Throwable)lazy.get()));
            return;
        }
        this.sharedLock.doExclusive(() -> {
            Collection<RedisCommand<RedisCommand<?, ?, ?>, RedisCommand<?, ?, ?>, RedisCommand<?, ?, ?>>> commands = queuedCommands.drainQueue();
            if (this.debugEnabled) {
                logger.debug("{} notifyQueuedCommands adding {} command(s) to buffer", (Object)this.logPrefix(), (Object)commands.size());
            }
            DefaultEndpoint.drainCommands(this.disconnectedBuffer, commands);
            for (RedisCommand<?, ?, ?> redisCommand : commands) {
                if (!(redisCommand instanceof DemandAware.Sink)) continue;
                ((DemandAware.Sink)((Object)redisCommand)).removeSource();
            }
            try {
                this.disconnectedBuffer.addAll(commands);
            }
            catch (RuntimeException e) {
                if (this.debugEnabled) {
                    logger.debug("{} notifyQueuedCommands Queue overcommit. Cannot add all commands to buffer (disconnected).", (Object)this.logPrefix(), (Object)commands.size());
                }
                commands.removeAll(this.disconnectedBuffer);
                for (RedisCommand<?, ?, ?> redisCommand : commands) {
                    redisCommand.completeExceptionally(e);
                }
            }
            if (this.isConnected()) {
                this.flushCommands(this.disconnectedBuffer);
            }
        });
    }

    public boolean isClosed() {
        return STATUS.get(this) == 1;
    }

    protected <T> T doExclusive(Supplier<T> supplier) {
        return this.sharedLock.doExclusive(supplier);
    }

    protected List<RedisCommand<?, ?, ?>> drainCommands() {
        ArrayList target = new ArrayList(this.disconnectedBuffer.size() + this.commandBuffer.size());
        DefaultEndpoint.drainCommands(this.disconnectedBuffer, target);
        DefaultEndpoint.drainCommands(this.commandBuffer, target);
        return target;
    }

    private static List<RedisCommand<?, ?, ?>> drainCommands(Queue<? extends RedisCommand<?, ?, ?>> source2) {
        RedisCommand<?, ?, ?> cmd;
        ArrayList target = new ArrayList(source2.size());
        while ((cmd = source2.poll()) != null) {
            if (cmd.isDone() || ActivationCommand.isActivationCommand(cmd)) continue;
            target.add(cmd);
        }
        DefaultEndpoint.drainCommands(source2, target);
        return target;
    }

    private static void drainCommands(Queue<? extends RedisCommand<?, ?, ?>> source2, Collection<RedisCommand<?, ?, ?>> target) {
        RedisCommand<?, ?, ?> cmd;
        while ((cmd = source2.poll()) != null) {
            if (cmd.isDone() || ActivationCommand.isActivationCommand(cmd)) continue;
            target.add(cmd);
        }
    }

    private void cancelBufferedCommands(String message) {
        this.cancelCommands(message, this.doExclusive(this::drainCommands), RedisCommand::cancel);
    }

    private void cancelCommands(String message, Iterable<? extends RedisCommand<?, ?, ?>> toCancel, Consumer<RedisCommand<?, ?, ?>> commandConsumer) {
        for (RedisCommand<?, ?, ?> cmd : toCancel) {
            if (cmd.getOutput() != null) {
                cmd.getOutput().setError(message);
            }
            commandConsumer.accept(cmd);
        }
    }

    private boolean isConnected() {
        Channel channel = this.channel;
        return channel != null && channel.isActive();
    }

    protected String logPrefix() {
        String buffer;
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        this.logPrefix = buffer = "[" + ChannelLogDescriptor.logDescriptor(this.channel) + ", epid=" + this.getId() + ']';
        return this.logPrefix;
    }

    protected ProtocolVersion getProtocolVersion() {
        return this.clientOptions.getProtocolVersion();
    }

    @Override
    public String getId() {
        return this.cachedEndpointId;
    }

    private static boolean isRejectCommand(ClientOptions clientOptions) {
        switch (clientOptions.getDisconnectedBehavior()) {
            case REJECT_COMMANDS: {
                return true;
            }
            case ACCEPT_COMMANDS: {
                return false;
            }
        }
        return !clientOptions.isAutoReconnect();
    }

    static class Lazy<T>
    implements Supplier<T> {
        private static final Lazy<?> EMPTY = new Lazy<Object>(() -> null, null, true);
        static final String UNRESOLVED = "[Unresolved]";
        private final Supplier<? extends T> supplier;
        private T value;
        private volatile boolean resolved;

        private Lazy(Supplier<? extends T> supplier) {
            this(supplier, null, false);
        }

        private Lazy(Supplier<? extends T> supplier, T value, boolean resolved) {
            this.supplier = supplier;
            this.value = value;
            this.resolved = resolved;
        }

        public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
            return new Lazy<T>(supplier);
        }

        public static <T> Lazy<T> empty() {
            return EMPTY;
        }

        @Override
        public T get() {
            T value = this.getNullable();
            if (value == null) {
                throw new IllegalStateException("Expected lazy evaluation to yield a non-null value but got null");
            }
            return value;
        }

        public T getNullable() {
            if (this.resolved) {
                return this.value;
            }
            this.value = this.supplier.get();
            this.resolved = true;
            return this.value;
        }
    }

    private static enum Reliability {
        AT_MOST_ONCE,
        AT_LEAST_ONCE;

    }

    static class RetryListener
    extends ListenerSupport
    implements GenericFutureListener<Future<Void>> {
        private static final Recycler<RetryListener> RECYCLER = new Recycler<RetryListener>(){

            protected RetryListener newObject(Recycler.Handle<RetryListener> handle) {
                return new RetryListener(handle);
            }
        };
        private final Recycler.Handle<RetryListener> handle;

        RetryListener(Recycler.Handle<RetryListener> handle) {
            this.handle = handle;
        }

        static RetryListener newInstance(DefaultEndpoint endpoint, RedisCommand<?, ?, ?> command) {
            RetryListener entry = (RetryListener)RECYCLER.get();
            entry.endpoint = endpoint;
            entry.sentCommand = command;
            return entry;
        }

        static RetryListener newInstance(DefaultEndpoint endpoint, Collection<? extends RedisCommand<?, ?, ?>> commands) {
            RetryListener entry = (RetryListener)RECYCLER.get();
            entry.endpoint = endpoint;
            entry.sentCommands = commands;
            return entry;
        }

        public void operationComplete(Future<Void> future) {
            try {
                this.doComplete(future);
            }
            finally {
                this.recycle();
            }
        }

        private void doComplete(Future<Void> future) {
            Throwable cause = future.cause();
            boolean success = future.isSuccess();
            this.dequeue();
            if (success) {
                return;
            }
            if (cause instanceof EncoderException || cause instanceof Error || cause.getCause() instanceof Error) {
                this.complete(cause);
                return;
            }
            Channel channel = this.endpoint.channel;
            RedisCommand sentCommand = this.sentCommand;
            Collection sentCommands = this.sentCommands;
            this.potentiallyRequeueCommands(channel, sentCommand, sentCommands);
            if (!(cause instanceof ClosedChannelException)) {
                String message = "Unexpected exception during request: {}";
                InternalLogLevel logLevel = InternalLogLevel.WARN;
                if (cause instanceof IOException && CommandHandler.SUPPRESS_IO_EXCEPTION_MESSAGES.contains(cause.getMessage())) {
                    logLevel = InternalLogLevel.DEBUG;
                }
                logger.log(logLevel, message, (Object)cause.toString(), (Object)cause);
            }
        }

        private void potentiallyRequeueCommands(Channel channel, RedisCommand<?, ?, ?> sentCommand, Collection<? extends RedisCommand<?, ?, ?>> sentCommands) {
            if (sentCommand != null && sentCommand.isDone()) {
                return;
            }
            if (sentCommands != null) {
                boolean foundToSend = false;
                for (RedisCommand<?, ?, ?> command : sentCommands) {
                    if (command.isDone()) continue;
                    foundToSend = true;
                    break;
                }
                if (!foundToSend) {
                    return;
                }
            }
            if (channel != null) {
                DefaultEndpoint endpoint = this.endpoint;
                channel.eventLoop().submit(() -> this.requeueCommands(sentCommand, sentCommands, endpoint));
            } else {
                this.requeueCommands(sentCommand, sentCommands, this.endpoint);
            }
        }

        private void requeueCommands(RedisCommand<?, ?, ?> sentCommand, Collection<? extends RedisCommand<?, ?, ?>> sentCommands, DefaultEndpoint endpoint) {
            if (sentCommand != null) {
                try {
                    endpoint.write(sentCommand);
                }
                catch (Exception e) {
                    sentCommand.completeExceptionally(e);
                }
            } else {
                try {
                    endpoint.write(sentCommands);
                }
                catch (Exception e) {
                    for (RedisCommand<?, ?, ?> command : sentCommands) {
                        command.completeExceptionally(e);
                    }
                }
            }
        }

        private void recycle() {
            this.endpoint = null;
            this.sentCommand = null;
            this.sentCommands = null;
            this.handle.recycle((Object)this);
        }
    }

    static class AtMostOnceWriteListener
    extends ListenerSupport
    implements ChannelFutureListener {
        private static final Recycler<AtMostOnceWriteListener> RECYCLER = new Recycler<AtMostOnceWriteListener>(){

            protected AtMostOnceWriteListener newObject(Recycler.Handle<AtMostOnceWriteListener> handle) {
                return new AtMostOnceWriteListener(handle);
            }
        };
        private final Recycler.Handle<AtMostOnceWriteListener> handle;

        AtMostOnceWriteListener(Recycler.Handle<AtMostOnceWriteListener> handle) {
            this.handle = handle;
        }

        static AtMostOnceWriteListener newInstance(DefaultEndpoint endpoint, RedisCommand<?, ?, ?> command) {
            AtMostOnceWriteListener entry = (AtMostOnceWriteListener)RECYCLER.get();
            entry.endpoint = endpoint;
            entry.sentCommand = command;
            return entry;
        }

        static AtMostOnceWriteListener newInstance(DefaultEndpoint endpoint, Collection<? extends RedisCommand<?, ?, ?>> commands) {
            AtMostOnceWriteListener entry = (AtMostOnceWriteListener)RECYCLER.get();
            entry.endpoint = endpoint;
            entry.sentCommands = commands;
            return entry;
        }

        public void operationComplete(ChannelFuture future) {
            try {
                this.dequeue();
                if (!future.isSuccess() && future.cause() != null) {
                    this.complete(future.cause());
                }
            }
            finally {
                this.recycle();
            }
        }

        private void recycle() {
            this.endpoint = null;
            this.sentCommand = null;
            this.sentCommands = null;
            this.handle.recycle((Object)this);
        }
    }

    static class ListenerSupport {
        Collection<? extends RedisCommand<?, ?, ?>> sentCommands;
        RedisCommand<?, ?, ?> sentCommand;
        DefaultEndpoint endpoint;

        ListenerSupport() {
        }

        void dequeue() {
            if (this.sentCommand != null) {
                QUEUE_SIZE.decrementAndGet(this.endpoint);
            } else {
                QUEUE_SIZE.addAndGet(this.endpoint, -this.sentCommands.size());
            }
        }

        protected void complete(Throwable t) {
            if (this.sentCommand != null) {
                this.sentCommand.completeExceptionally(t);
            } else {
                for (RedisCommand<?, ?, ?> sentCommand : this.sentCommands) {
                    sentCommand.completeExceptionally(t);
                }
            }
        }
    }
}

