/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.internal.LettuceAssert;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class SharedLock {
    private static final AtomicLongFieldUpdater<SharedLock> WRITERS = AtomicLongFieldUpdater.newUpdater(SharedLock.class, "writers");
    private final Lock lock = new ReentrantLock();
    private volatile long writers = 0L;
    private volatile Thread exclusiveLockOwner;

    SharedLock() {
    }

    void incrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        this.lock.lock();
        try {
            while (WRITERS.get(this) < 0L) {
            }
            WRITERS.incrementAndGet(this);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    void decrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        WRITERS.decrementAndGet(this);
    }

    void doExclusive(Runnable runnable2) {
        LettuceAssert.notNull((Object)runnable2, "Runnable must not be null");
        this.doExclusive(() -> {
            runnable2.run();
            return null;
        });
    }

    <T> T doExclusive(Supplier<T> supplier) {
        LettuceAssert.notNull(supplier, "Supplier must not be null");
        this.lock.lock();
        try {
            T t;
            try {
                this.lockWritersExclusive();
                t = supplier.get();
                this.unlockWritersExclusive();
            }
            catch (Throwable throwable) {
                this.unlockWritersExclusive();
                throw throwable;
            }
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void lockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            WRITERS.decrementAndGet(this);
            return;
        }
        this.lock.lock();
        try {
            while (!WRITERS.compareAndSet(this, 0L, -1L)) {
            }
            this.exclusiveLockOwner = Thread.currentThread();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unlockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread() && WRITERS.incrementAndGet(this) == 0L) {
            this.exclusiveLockOwner = null;
        }
    }
}

