/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.entities.channel;

import java.util.Collection;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.dv8tion.jda.internal.utils.Checks;

public enum ChannelFlag {
    PINNED(2),
    REQUIRE_TAG(16),
    HIDE_MEDIA_DOWNLOAD_OPTIONS(32768);

    private final int value;

    private ChannelFlag(int value) {
        this.value = value;
    }

    public int getRaw() {
        return this.value;
    }

    @Nonnull
    public static EnumSet<ChannelFlag> fromRaw(int bitset) {
        EnumSet<ChannelFlag> set2 = EnumSet.noneOf(ChannelFlag.class);
        if (bitset == 0) {
            return set2;
        }
        for (ChannelFlag flag : ChannelFlag.values()) {
            if (flag.value != bitset) continue;
            set2.add(flag);
        }
        return set2;
    }

    public static int getRaw(@Nonnull Collection<ChannelFlag> flags) {
        Checks.notNull(flags, "Flags");
        int raw = 0;
        for (ChannelFlag flag : flags) {
            raw |= flag.getRaw();
        }
        return raw;
    }
}

