/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio._UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0002()B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u000eH$J\b\u0010\u0016\u001a\u00020\u000eH$J(\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH$J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0011H$J\b\u0010\u001f\u001a\u00020\u0011H$J(\u0010 \u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH$J&\u0010!\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010!\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011J \u0010#\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0016\u0010$\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010$\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\u0011J\u0006\u0010\u001e\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u0011J&\u0010&\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010&\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011J \u0010'\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lokio/FileHandle;", "Ljava/io/Closeable;", "Lokio/Closeable;", "readWrite", "", "(Z)V", "closed", "openStreamCount", "", "getReadWrite", "()Z", "appendingSink", "Lokio/Sink;", "close", "", "flush", "position", "", "sink", "source", "Lokio/Source;", "protectedClose", "protectedFlush", "protectedRead", "fileOffset", "array", "", "arrayOffset", "byteCount", "protectedResize", "size", "protectedSize", "protectedWrite", "read", "Lokio/Buffer;", "readNoCloseCheck", "reposition", "resize", "write", "writeNoCloseCheck", "FileHandleSink", "FileHandleSource", "okio"})
public abstract class FileHandle
implements Closeable {
    private final boolean readWrite;
    private boolean closed;
    private int openStreamCount;

    public FileHandle(boolean readWrite2) {
        this.readWrite = readWrite2;
    }

    public final boolean getReadWrite() {
        return this.readWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(array, "array");
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            boolean bl4 = !this.closed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.protectedRead(fileOffset, array, arrayOffset, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long read(long fileOffset, @NotNull Buffer sink2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            boolean bl4 = !this.closed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.readNoCloseCheck(fileOffset, sink2, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long size() throws IOException {
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            boolean bl4 = !this.closed;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.protectedSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resize(long size) throws IOException {
        boolean bl = this.readWrite;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "file handle is read-only";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean $i$f$synchronized = false;
        bl2 = false;
        bl3 = false;
        synchronized (this) {
            boolean bl5 = false;
            boolean bl6 = !this.closed;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        this.protectedResize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(long fileOffset, @NotNull byte[] array, int arrayOffset, int byteCount) {
        Intrinsics.checkNotNullParameter(array, "array");
        boolean bl = this.readWrite;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "file handle is read-only";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean $i$f$synchronized = false;
        bl2 = false;
        bl3 = false;
        synchronized (this) {
            boolean bl5 = false;
            boolean bl6 = !this.closed;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        this.protectedWrite(fileOffset, array, arrayOffset, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(long fileOffset, @NotNull Buffer source2, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        boolean bl = this.readWrite;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "file handle is read-only";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean $i$f$synchronized = false;
        bl2 = false;
        bl3 = false;
        synchronized (this) {
            boolean bl5 = false;
            boolean bl6 = !this.closed;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        this.writeNoCloseCheck(fileOffset, source2, byteCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() throws IOException {
        boolean bl = this.readWrite;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "file handle is read-only";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean $i$f$synchronized = false;
        bl2 = false;
        bl3 = false;
        synchronized (this) {
            boolean bl5 = false;
            boolean bl6 = !this.closed;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl6) {
                boolean bl9 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Unit unit = Unit.INSTANCE;
        }
        this.protectedFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Source source(long fileOffset) throws IOException {
        boolean $i$f$synchronized = false;
        boolean bl = false;
        int n = 0;
        synchronized (this) {
            boolean bl2 = false;
            boolean bl3 = !this.closed;
            int n2 = 0;
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FileHandle fileHandle = this;
            n2 = fileHandle.openStreamCount;
            fileHandle.openStreamCount = n2 + 1;
            n = n2;
        }
        return new FileHandleSource(this, fileOffset);
    }

    public static /* synthetic */ Source source$default(FileHandle fileHandle, long l, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: source");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return fileHandle.source(l);
    }

    public final long position(@NotNull Source source2) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        Source source3 = source2;
        long bufferSize = 0L;
        if (source3 instanceof RealBufferedSource) {
            RealBufferedSource this_$iv = (RealBufferedSource)source3;
            boolean $i$f$getBuffer = false;
            bufferSize = this_$iv.bufferField.size();
            source3 = ((RealBufferedSource)source3).source;
        }
        boolean bl = source3 instanceof FileHandleSource && ((FileHandleSource)source3).getFileHandle() == this;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "source was not created by this FileHandle";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !((FileHandleSource)source3).getClosed();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((FileHandleSource)source3).getPosition() - bufferSize;
    }

    public final void reposition(@NotNull Source source2, long position) throws IOException {
        Intrinsics.checkNotNullParameter(source2, "source");
        if (source2 instanceof RealBufferedSource) {
            Source fileHandleSource = ((RealBufferedSource)source2).source;
            boolean bl = fileHandleSource instanceof FileHandleSource && ((FileHandleSource)fileHandleSource).getFileHandle() == this;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "source was not created by this FileHandle";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = !((FileHandleSource)fileHandleSource).getClosed();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            RealBufferedSource this_$iv = (RealBufferedSource)source2;
            boolean $i$f$getBuffer = false;
            long bufferSize = this_$iv.bufferField.size();
            long toSkip = position - (((FileHandleSource)fileHandleSource).getPosition() - bufferSize);
            boolean bl6 = 0L <= toSkip ? toSkip < bufferSize : false;
            if (bl6) {
                ((RealBufferedSource)source2).skip(toSkip);
            } else {
                RealBufferedSource this_$iv2 = (RealBufferedSource)source2;
                boolean $i$f$getBuffer2 = false;
                this_$iv2.bufferField.clear();
                ((FileHandleSource)fileHandleSource).setPosition(position);
            }
        } else {
            boolean bl = source2 instanceof FileHandleSource && ((FileHandleSource)source2).getFileHandle() == this;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!bl) {
                boolean bl9 = false;
                String string = "source was not created by this FileHandle";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = !((FileHandleSource)source2).getClosed();
            bl7 = false;
            bl8 = false;
            if (!bl) {
                boolean bl10 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ((FileHandleSource)source2).setPosition(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Sink sink(long fileOffset) throws IOException {
        boolean bl = this.readWrite;
        boolean bl2 = false;
        int n = 0;
        if (!bl) {
            boolean bl3 = false;
            String string = "file handle is read-only";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean $i$f$synchronized = false;
        bl2 = false;
        n = 0;
        synchronized (this) {
            boolean bl4 = false;
            boolean bl5 = !this.closed;
            int n2 = 0;
            boolean bl6 = false;
            if (!bl5) {
                boolean bl7 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            FileHandle fileHandle = this;
            n2 = fileHandle.openStreamCount;
            fileHandle.openStreamCount = n2 + 1;
            n = n2;
        }
        return new FileHandleSink(this, fileOffset);
    }

    public static /* synthetic */ Sink sink$default(FileHandle fileHandle, long l, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sink");
        }
        if ((n & 1) != 0) {
            l = 0L;
        }
        return fileHandle.sink(l);
    }

    @NotNull
    public final Sink appendingSink() throws IOException {
        return this.sink(this.size());
    }

    public final long position(@NotNull Sink sink2) throws IOException {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Sink sink3 = sink2;
        long bufferSize = 0L;
        if (sink3 instanceof RealBufferedSink) {
            RealBufferedSink this_$iv = (RealBufferedSink)sink3;
            boolean $i$f$getBuffer = false;
            bufferSize = this_$iv.bufferField.size();
            sink3 = ((RealBufferedSink)sink3).sink;
        }
        boolean bl = sink3 instanceof FileHandleSink && ((FileHandleSink)sink3).getFileHandle() == this;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "sink was not created by this FileHandle";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !((FileHandleSink)sink3).getClosed();
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "closed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((FileHandleSink)sink3).getPosition() + bufferSize;
    }

    public final void reposition(@NotNull Sink sink2, long position) throws IOException {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        if (sink2 instanceof RealBufferedSink) {
            Sink fileHandleSink = ((RealBufferedSink)sink2).sink;
            boolean bl = fileHandleSink instanceof FileHandleSink && ((FileHandleSink)fileHandleSink).getFileHandle() == this;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "sink was not created by this FileHandle";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = !((FileHandleSink)fileHandleSink).getClosed();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ((RealBufferedSink)sink2).emit();
            ((FileHandleSink)fileHandleSink).setPosition(position);
        } else {
            boolean bl = sink2 instanceof FileHandleSink && ((FileHandleSink)sink2).getFileHandle() == this;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                boolean bl8 = false;
                String string = "sink was not created by this FileHandle";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = !((FileHandleSink)sink2).getClosed();
            bl6 = false;
            bl7 = false;
            if (!bl) {
                boolean bl9 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ((FileHandleSink)sink2).setPosition(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (this) {
            boolean bl3 = false;
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.openStreamCount != 0) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        this.protectedClose();
    }

    protected abstract int protectedRead(long var1, @NotNull byte[] var3, int var4, int var5) throws IOException;

    protected abstract void protectedWrite(long var1, @NotNull byte[] var3, int var4, int var5) throws IOException;

    protected abstract void protectedFlush() throws IOException;

    protected abstract void protectedResize(long var1) throws IOException;

    protected abstract long protectedSize() throws IOException;

    protected abstract void protectedClose() throws IOException;

    /*
     * WARNING - void declaration
     */
    private final long readNoCloseCheck(long fileOffset, Buffer sink2, long byteCount) {
        long currentOffset;
        int readByteCount;
        boolean bl = byteCount >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus("byteCount < 0: ", byteCount);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long targetOffset = fileOffset + byteCount;
        for (currentOffset = fileOffset; currentOffset < targetOffset; currentOffset += (long)readByteCount) {
            void a$iv;
            Segment tail = sink2.writableSegment$okio(1);
            long l = targetOffset - currentOffset;
            int b$iv = 8192 - tail.limit;
            boolean $i$f$minOf = false;
            long l2 = b$iv;
            boolean bl5 = false;
            readByteCount = this.protectedRead(currentOffset, tail.data, tail.limit, (int)Math.min((long)a$iv, l2));
            if (readByteCount == -1) {
                if (tail.pos == tail.limit) {
                    sink2.head = tail.pop();
                    SegmentPool.recycle(tail);
                }
                if (fileOffset != currentOffset) break;
                return -1L;
            }
            Object object = tail;
            ((Segment)object).limit += readByteCount;
            object = sink2;
            ((Buffer)object).setSize$okio(((Buffer)object).size() + (long)readByteCount);
        }
        return currentOffset - fileOffset;
    }

    /*
     * WARNING - void declaration
     */
    private final void writeNoCloseCheck(long fileOffset, Buffer source2, long byteCount) {
        int toCopy;
        _UtilKt.checkOffsetAndCount(source2.size(), 0L, byteCount);
        long targetOffset = fileOffset + byteCount;
        for (long currentOffset = fileOffset; currentOffset < targetOffset; currentOffset += (long)toCopy) {
            void a$iv;
            Segment head;
            Intrinsics.checkNotNull(source2.head);
            long l = targetOffset - currentOffset;
            int b$iv = head.limit - head.pos;
            boolean $i$f$minOf = false;
            long l2 = b$iv;
            boolean bl = false;
            toCopy = (int)Math.min((long)a$iv, l2);
            this.protectedWrite(currentOffset, head.data, head.pos, toCopy);
            Object object = head;
            ((Segment)object).pos += toCopy;
            object = source2;
            ((Buffer)object).setSize$okio(((Buffer)object).size() - (long)toCopy);
            if (head.pos != head.limit) continue;
            source2.head = head.pop();
            SegmentPool.recycle(head);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lokio/FileHandle$FileHandleSink;", "Lokio/Sink;", "fileHandle", "Lokio/FileHandle;", "position", "", "(Lokio/FileHandle;J)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "getFileHandle", "()Lokio/FileHandle;", "getPosition", "()J", "setPosition", "(J)V", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "okio"})
    private static final class FileHandleSink
    implements Sink {
        @NotNull
        private final FileHandle fileHandle;
        private long position;
        private boolean closed;

        public FileHandleSink(@NotNull FileHandle fileHandle, long position) {
            Intrinsics.checkNotNullParameter(fileHandle, "fileHandle");
            this.fileHandle = fileHandle;
            this.position = position;
        }

        @NotNull
        public final FileHandle getFileHandle() {
            return this.fileHandle;
        }

        public final long getPosition() {
            return this.position;
        }

        public final void setPosition(long l) {
            this.position = l;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter(source2, "source");
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.fileHandle.writeNoCloseCheck(this.position, source2, byteCount);
            FileHandleSink fileHandleSink = this;
            fileHandleSink.position += byteCount;
        }

        @Override
        public void flush() {
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.fileHandle.protectedFlush();
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FileHandle lock$iv = this.fileHandle;
            boolean $i$f$synchronized = false;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (lock$iv) {
                boolean bl3 = false;
                FileHandle fileHandle = this.getFileHandle();
                int n = fileHandle.openStreamCount;
                fileHandle.openStreamCount = n + -1;
                if (this.getFileHandle().openStreamCount != 0 || !this.getFileHandle().closed) {
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            this.fileHandle.protectedClose();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lokio/FileHandle$FileHandleSource;", "Lokio/Source;", "fileHandle", "Lokio/FileHandle;", "position", "", "(Lokio/FileHandle;J)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "getFileHandle", "()Lokio/FileHandle;", "getPosition", "()J", "setPosition", "(J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "okio"})
    private static final class FileHandleSource
    implements Source {
        @NotNull
        private final FileHandle fileHandle;
        private long position;
        private boolean closed;

        public FileHandleSource(@NotNull FileHandle fileHandle, long position) {
            Intrinsics.checkNotNullParameter(fileHandle, "fileHandle");
            this.fileHandle = fileHandle;
            this.position = position;
        }

        @NotNull
        public final FileHandle getFileHandle() {
            return this.fileHandle;
        }

        public final long getPosition() {
            return this.position;
        }

        public final void setPosition(long l) {
            this.position = l;
        }

        public final boolean getClosed() {
            return this.closed;
        }

        public final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter(sink2, "sink");
            boolean bl = !this.closed;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "closed";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            long result = this.fileHandle.readNoCloseCheck(this.position, sink2, byteCount);
            if (result != -1L) {
                FileHandleSource fileHandleSource = this;
                fileHandleSource.position += result;
            }
            return result;
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return Timeout.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FileHandle lock$iv = this.fileHandle;
            boolean $i$f$synchronized = false;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (lock$iv) {
                boolean bl3 = false;
                FileHandle fileHandle = this.getFileHandle();
                int n = fileHandle.openStreamCount;
                fileHandle.openStreamCount = n + -1;
                if (this.getFileHandle().openStreamCount != 0 || !this.getFileHandle().closed) {
                    return;
                }
                Unit unit = Unit.INSTANCE;
            }
            this.fileHandle.protectedClose();
        }
    }
}

