/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.swing.binding;

import groovy.lang.Closure;
import groovy.lang.Reference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import org.apache.groovy.swing.binding.BindPath;
import org.apache.groovy.swing.binding.BindPathSnooper;
import org.apache.groovy.swing.binding.ClosureSourceBinding;
import org.apache.groovy.swing.binding.DeadEndException;
import org.apache.groovy.swing.binding.FullBinding;
import org.apache.groovy.swing.binding.PropertyPathFullBinding;
import org.apache.groovy.swing.binding.SourceBinding;
import org.apache.groovy.swing.binding.TargetBinding;
import org.apache.groovy.swing.binding.TriggerBinding;
import org.codehaus.groovy.reflection.ReflectionUtils;

public class ClosureTriggerBinding
implements TriggerBinding,
SourceBinding {
    private static final BindPath[] EMPTY_BINDPATH_ARRAY = new BindPath[0];
    Map<String, TriggerBinding> syntheticBindings;
    Closure closure;

    public ClosureTriggerBinding(Map<String, TriggerBinding> syntheticBindings) {
        this.syntheticBindings = syntheticBindings;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public void setClosure(Closure closure) {
        this.closure = closure;
    }

    private BindPath createBindPath(String propertyName, BindPathSnooper snooper) {
        BindPath bp = new BindPath();
        bp.propertyName = propertyName;
        bp.updateLocalSyntheticProperties(this.syntheticBindings);
        ArrayList<BindPath> childPaths = new ArrayList<BindPath>();
        for (Map.Entry<String, BindPathSnooper> entry : snooper.fields.entrySet()) {
            childPaths.add(this.createBindPath(entry.getKey(), entry.getValue()));
        }
        bp.children = childPaths.toArray(EMPTY_BINDPATH_ARRAY);
        return bp;
    }

    @Override
    public FullBinding createBinding(SourceBinding source2, TargetBinding target) {
        if (source2 != this) {
            throw new RuntimeException("Source binding must the Trigger Binding as well");
        }
        final BindPathSnooper delegate = new BindPathSnooper();
        try {
            final Class<?> closureClass = this.closure.getClass();
            Closure closureLocalCopy = ClosureTriggerBinding.doPrivileged(new PrivilegedAction<Closure>(){

                @Override
                public Closure run() {
                    Constructor<?> constructor = closureClass.getConstructors()[0];
                    int paramCount = constructor.getParameterTypes().length;
                    Object[] args2 = new Object[paramCount];
                    args2[0] = delegate;
                    for (int i = 1; i < paramCount; ++i) {
                        args2[i] = new Reference<BindPathSnooper>(new BindPathSnooper());
                    }
                    try {
                        boolean acc = ClosureTriggerBinding.this.isAccessible(constructor);
                        ReflectionUtils.trySetAccessible(constructor);
                        Closure localCopy = (Closure)constructor.newInstance(args2);
                        if (!acc) {
                            constructor.setAccessible(false);
                        }
                        localCopy.setResolveStrategy(3);
                        for (Field f : closureClass.getDeclaredFields()) {
                            acc = ClosureTriggerBinding.this.isAccessible(f);
                            ReflectionUtils.trySetAccessible(f);
                            if (f.getType() == Reference.class) {
                                delegate.fields.put(f.getName(), (BindPathSnooper)((Reference)f.get(localCopy)).get());
                            }
                            if (acc) continue;
                            f.setAccessible(false);
                        }
                        return localCopy;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error snooping closure", e);
                    }
                }
            });
            try {
                closureLocalCopy.call();
            }
            catch (DeadEndException deadEndException) {
                throw deadEndException;
            }
            catch (Exception exception) {
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new RuntimeException("A closure expression binding could not be created because of " + e.getClass().getName() + ":\n\t" + e.getMessage());
        }
        ArrayList<BindPath> rootPaths = new ArrayList<BindPath>();
        for (Map.Entry entry : delegate.fields.entrySet()) {
            BindPath bp = this.createBindPath((String)entry.getKey(), (BindPathSnooper)entry.getValue());
            bp.currentObject = this.closure;
            rootPaths.add(bp);
        }
        PropertyPathFullBinding fb = new PropertyPathFullBinding();
        fb.setSourceBinding(new ClosureSourceBinding(this.closure));
        fb.setTargetBinding(target);
        fb.bindPaths = rootPaths.toArray(EMPTY_BINDPATH_ARRAY);
        return fb;
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    private boolean isAccessible(AccessibleObject accessibleObject) {
        return accessibleObject.isAccessible();
    }

    @Override
    public Object getSourceValue() {
        return this.closure.call();
    }
}

