/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.runtime;

import groovy.lang.Closure;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.groovy.lang.annotation.Incubating;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;

@Incubating
public enum MacroBuilder {
    INSTANCE;

    private static final AtomicInteger COUNTER;

    public <T> T macro(String source2, List<Closure<Expression>> context, Class<T> resultClass) {
        return this.macro(false, source2, context, resultClass);
    }

    public <T> T macro(boolean asIs, String source2, List<Closure<Expression>> context, Class<T> resultClass) {
        return this.macro(null, asIs, source2, context, resultClass);
    }

    public <T> T macro(CompilePhase compilePhase, String source2, List<Closure<Expression>> context, Class<T> resultClass) {
        return this.macro(compilePhase, false, source2, context, resultClass);
    }

    public <T> T macro(CompilePhase compilePhase, boolean asIs, String source2, List<Closure<Expression>> context, Class<T> resultClass) {
        boolean isClosure = source2.startsWith("{");
        String label = isClosure ? "__synthesized__label__" + COUNTER.incrementAndGet() + "__:" : "";
        String labelledSource = label + source2;
        if (compilePhase == null) {
            compilePhase = CompilePhase.CONVERSION;
        }
        List<ASTNode> nodes = new AstBuilder().buildFromString(compilePhase, true, labelledSource);
        for (ASTNode node : nodes) {
            List<Statement> statements;
            if (node instanceof BlockStatement && !(statements = ((BlockStatement)node).getStatements()).isEmpty()) {
                BlockStatement closureBlock = (BlockStatement)statements.get(0);
                MacroBuilder.performSubstitutions(context, closureBlock);
                return (T)MacroBuilder.getMacroValue(closureBlock, asIs);
            }
            if (!(node instanceof ClassNode)) continue;
            MacroBuilder.performSubstitutions(context, node);
            return (T)node;
        }
        return null;
    }

    private static void performSubstitutions(List<Closure<Expression>> context, ASTNode astNode) {
        final Iterator<Closure<Expression>> iterator2 = context.iterator();
        ClassCodeExpressionTransformer trn = new ClassCodeExpressionTransformer(){

            @Override
            public Expression transform(Expression expression) {
                if (!(expression instanceof MethodCallExpression)) {
                    return super.transform(expression);
                }
                MethodCallExpression call = (MethodCallExpression)expression;
                if (!"$v".equals(call.getMethodAsString())) {
                    return super.transform(expression);
                }
                return (Expression)((Closure)iterator2.next()).call();
            }

            @Override
            protected SourceUnit getSourceUnit() {
                return null;
            }
        };
        if (astNode instanceof BlockStatement) {
            trn.visitBlockStatement((BlockStatement)astNode);
        } else if (astNode instanceof ClassNode) {
            trn.visitClass((ClassNode)astNode);
        }
    }

    public static ASTNode getMacroValue(BlockStatement closureBlock, boolean asIs) {
        if (!asIs && closureBlock.getStatements().size() == 1) {
            Statement result = closureBlock.getStatements().get(0);
            if (result instanceof ExpressionStatement) {
                return ((ExpressionStatement)result).getExpression();
            }
            return result;
        }
        return closureBlock;
    }

    static {
        COUNTER = new AtomicInteger();
    }
}

