/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.transform;

import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodCallTransformation;
import org.codehaus.groovy.ast.TransformingCodeVisitor;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.macro.methods.MacroGroovyMethods;
import org.codehaus.groovy.macro.runtime.MacroBuilder;
import org.codehaus.groovy.macro.transform.MacroClass;
import org.codehaus.groovy.macro.transform.MacroTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public class MacroClassTransformation
extends MethodCallTransformation {
    private static final String MACRO_METHOD = "macro";
    private static final ClassNode MACROCLASS_TYPE = ClassHelper.make(MacroClass.class);

    @Override
    protected GroovyCodeVisitor getTransformer(ASTNode[] nodes, SourceUnit sourceUnit) {
        MacroClassTransformer transformer = new MacroClassTransformer(sourceUnit);
        return new MacroClassTransformingCodeVisitor(transformer, sourceUnit);
    }

    private static class MacroClassTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit sourceUnit;

        MacroClassTransformer(SourceUnit sourceUnit) {
            this.sourceUnit = sourceUnit;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }

        @Override
        public Expression transform(Expression exp) {
            MethodCallExpression call;
            if (exp instanceof ConstructorCallExpression && (call = (MethodCallExpression)exp.getNodeMetaData(MacroTransformation.class)) != null) {
                return call;
            }
            return super.transform(exp);
        }
    }

    private static class MacroClassTransformingCodeVisitor
    extends TransformingCodeVisitor {
        private final SourceUnit sourceUnit;

        MacroClassTransformingCodeVisitor(ClassCodeExpressionTransformer transformer, SourceUnit sourceUnit) {
            super(transformer);
            this.sourceUnit = sourceUnit;
        }

        @Override
        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            ClassNode type = call.getType();
            if (type instanceof InnerClassNode && ((InnerClassNode)type).isAnonymous() && MACROCLASS_TYPE.getNameWithoutPackage().equals(type.getSuperClass().getNameWithoutPackage())) {
                try {
                    String source2 = this.convertInnerClassToSource(type);
                    MethodCallExpression macroCall = GeneralUtils.callX((Expression)GeneralUtils.propX((Expression)GeneralUtils.classX(ClassHelper.makeWithoutCaching(MacroBuilder.class, false)), "INSTANCE"), MacroClassTransformation.MACRO_METHOD, (Expression)GeneralUtils.args(GeneralUtils.constX(source2), MacroGroovyMethods.buildSubstitutions(this.sourceUnit, type), GeneralUtils.classX(ClassHelper.make(ClassNode.class))));
                    macroCall.setSpreadSafe(false);
                    macroCall.setSafe(false);
                    macroCall.setImplicitThis(false);
                    call.putNodeMetaData(MacroTransformation.class, macroCall);
                    List<ClassNode> classes = this.sourceUnit.getAST().getClasses();
                    Iterator<ClassNode> iterator2 = classes.iterator();
                    while (iterator2.hasNext()) {
                        ClassNode aClass = iterator2.next();
                        if (aClass != type && type != aClass.getOuterClass()) continue;
                        iterator2.remove();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            super.visitConstructorCallExpression(call);
        }

        private String convertInnerClassToSource(ClassNode type) throws Exception {
            String source2 = GeneralUtils.convertASTToSource(this.sourceUnit.getSource(), type);
            source2 = source2.substring(source2.indexOf(123) + 1, source2.lastIndexOf(125) - 1);
            return source2;
        }
    }
}

